/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import androidx.annotation.NonNull;
import com.facebook.common.logging.FLog;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactInstancePackage;
import com.facebook.react.ReactPackage;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.ReactApplicationContext;
import java.util.Iterator;
import java.util.List;

public class ReactPackageHelper {
    static Iterable<ModuleHolder> getNativeModuleIterator(ReactPackage reactPackage, ReactApplicationContext reactApplicationContext, ReactInstanceManager reactInstanceManager) {
        List<NativeModule> nativeModules;
        FLog.d((String)"ReactNative", (String)(reactPackage.getClass().getSimpleName() + " is not a LazyReactPackage, falling back to old version."));
        if (reactPackage instanceof ReactInstancePackage) {
            ReactInstancePackage reactInstancePackage = (ReactInstancePackage)reactPackage;
            nativeModules = reactInstancePackage.createNativeModules(reactApplicationContext, reactInstanceManager);
        } else {
            nativeModules = reactPackage.createNativeModules(reactApplicationContext);
        }
        return new Iterable<ModuleHolder>(){

            @Override
            @NonNull
            public Iterator<ModuleHolder> iterator() {
                return new Iterator<ModuleHolder>(){
                    int position = 0;

                    @Override
                    public ModuleHolder next() {
                        return new ModuleHolder((NativeModule)nativeModules.get(this.position++));
                    }

                    @Override
                    public boolean hasNext() {
                        return this.position < nativeModules.size();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove methods ");
                    }
                };
            }
        };
    }
}

