/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.view.KeyEvent;
import android.view.View;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.SystemClock;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import java.util.Map;

public class ReactAndroidHWInputDeviceHelper {
    private static final Map<Integer, String> KEY_EVENTS_ACTIONS = MapBuilder.builder().put(23, "select").put(66, "select").put(160, "select").put(109, "select").put(62, "select").put(85, "playPause").put(126, "play").put(127, "pause").put(87, "next").put(88, "previous").put(89, "rewind").put(90, "fastForward").put(130, "record").put(86, "stop").put(87, "next").put(88, "previous").put(19, "up").put(22, "right").put(20, "down").put(21, "left").put(165, "info").put(175, "captions").put(82, "menu").put(7, "0").put(8, "1").put(9, "2").put(10, "3").put(11, "4").put(12, "5").put(13, "6").put(14, "7").put(15, "8").put(16, "9").put(167, "channelDown").put(166, "channelUp").build();
    private static final Map<Integer, String> KEY_EVENTS_LONG_PRESS_ACTIONS = MapBuilder.builder().put(23, "longSelect").put(66, "longSelect").put(160, "longSelect").put(109, "longSelect").put(19, "longUp").put(22, "longRight").put(20, "longDown").put(21, "longLeft").build();
    private int mLastFocusedViewId = -1;
    private long mLongPressedDelta = 300L;
    private long mLastKeyDownTime = 0L;
    private boolean longPressEventActive = false;

    private boolean isSelectEvent(int eventKeyCode) {
        return eventKeyCode == 23 || eventKeyCode == 109 || eventKeyCode == 160 || eventKeyCode == 66;
    }

    private boolean isDPadEvent(int eventKeyCode) {
        return eventKeyCode == 19 || eventKeyCode == 22 || eventKeyCode == 20 || eventKeyCode == 21;
    }

    private boolean isLongPressEventTime(long time) {
        return this.mLastKeyDownTime != 0L && time - this.mLastKeyDownTime > this.mLongPressedDelta;
    }

    public void handleKeyEvent(KeyEvent ev, ReactContext context) {
        boolean isSelectOrDPadEvent;
        int eventKeyCode = ev.getKeyCode();
        int eventKeyAction = ev.getAction();
        long time = SystemClock.uptimeMillis();
        boolean bl = isSelectOrDPadEvent = this.isDPadEvent(eventKeyCode) || this.isSelectEvent(eventKeyCode);
        if (eventKeyAction == 0 && isSelectOrDPadEvent) {
            if (this.mLastKeyDownTime == 0L) {
                this.mLastKeyDownTime = time;
            } else if (this.isLongPressEventTime(time)) {
                this.longPressEventActive = true;
            }
        }
        if (this.shouldDispatchEvent(eventKeyCode, eventKeyAction, time)) {
            if (this.longPressEventActive) {
                this.dispatchEvent(KEY_EVENTS_LONG_PRESS_ACTIONS.get(eventKeyCode), this.mLastFocusedViewId, ReactFeatureFlags.enableKeyDownEvents ? eventKeyAction : 1, context);
                this.mLastKeyDownTime = time;
            } else {
                this.dispatchEvent(KEY_EVENTS_ACTIONS.get(eventKeyCode), this.mLastFocusedViewId, eventKeyAction, context);
            }
        }
        if (eventKeyAction == 1 && isSelectOrDPadEvent) {
            this.mLastKeyDownTime = 0L;
            this.longPressEventActive = false;
        }
    }

    private boolean shouldDispatchEvent(int eventKeyCode, int eventKeyAction, long time) {
        return KEY_EVENTS_ACTIONS.containsKey(eventKeyCode) && (eventKeyAction == 1 || eventKeyAction == 0 && !this.longPressEventActive && ReactFeatureFlags.enableKeyDownEvents || eventKeyAction == 0 && this.longPressEventActive && this.isLongPressEventTime(time));
    }

    public void onFocusChanged(View newFocusedView, ReactContext context) {
        if (this.mLastFocusedViewId == newFocusedView.getId()) {
            return;
        }
        if (this.mLastFocusedViewId != -1) {
            this.dispatchEvent("blur", this.mLastFocusedViewId, context);
        }
        this.mLastFocusedViewId = newFocusedView.getId();
        this.dispatchEvent("focus", newFocusedView.getId(), context);
    }

    public void clearFocus(ReactContext context) {
        if (this.mLastFocusedViewId != -1) {
            this.dispatchEvent("blur", this.mLastFocusedViewId, context);
        }
        this.mLastFocusedViewId = -1;
    }

    private void dispatchEvent(String eventType, int targetViewId, ReactContext context) {
        this.dispatchEvent(eventType, targetViewId, -1, context);
    }

    private void dispatchEvent(String eventType, int targetViewId, int eventKeyAction, ReactContext context) {
        WritableNativeMap event = new WritableNativeMap();
        event.putString("eventType", eventType);
        event.putInt("eventKeyAction", eventKeyAction);
        if (targetViewId != -1) {
            event.putInt("tag", targetViewId);
            event.putInt("target", targetViewId);
        }
        this.emitNamedEvent("onHWKeyEvent", event, context);
    }

    public void emitNamedEvent(String eventName, WritableMap event, ReactContext context) {
        if (context != null) {
            context.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit(eventName, event);
        }
    }
}

