/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.drawer;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.drawerlayout.widget.DrawerLayout;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManagerDelegate;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.viewmanagers.AndroidDrawerLayoutManagerDelegate;
import com.facebook.react.viewmanagers.AndroidDrawerLayoutManagerInterface;
import com.facebook.react.views.drawer.ReactDrawerLayout;
import com.facebook.react.views.drawer.events.DrawerClosedEvent;
import com.facebook.react.views.drawer.events.DrawerOpenedEvent;
import com.facebook.react.views.drawer.events.DrawerSlideEvent;
import com.facebook.react.views.drawer.events.DrawerStateChangedEvent;
import java.util.HashMap;
import java.util.Map;

@ReactModule(name="AndroidDrawerLayout")
public class ReactDrawerLayoutManager
extends ViewGroupManager<ReactDrawerLayout>
implements AndroidDrawerLayoutManagerInterface<ReactDrawerLayout> {
    public static final String REACT_CLASS = "AndroidDrawerLayout";
    public static final int OPEN_DRAWER = 1;
    public static final int CLOSE_DRAWER = 2;
    private final ViewManagerDelegate<ReactDrawerLayout> mDelegate = new AndroidDrawerLayoutManagerDelegate<ReactDrawerLayout, ReactDrawerLayoutManager>(this);

    @Override
    @NonNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected void addEventEmitters(@NonNull ThemedReactContext reactContext, ReactDrawerLayout view) {
        EventDispatcher eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag(reactContext, view.getId());
        if (eventDispatcher == null) {
            return;
        }
        view.addDrawerListener(new DrawerEventEmitter(view, eventDispatcher));
    }

    @Override
    @NonNull
    protected ReactDrawerLayout createViewInstance(@NonNull ThemedReactContext context) {
        return new ReactDrawerLayout(context);
    }

    @Override
    public void setDrawerPosition(ReactDrawerLayout view, @Nullable String value) {
        if (value == null) {
            view.setDrawerPosition(0x800003);
        } else {
            this.setDrawerPositionInternal(view, value);
        }
    }

    @ReactProp(name="drawerPosition")
    public void setDrawerPosition(ReactDrawerLayout view, Dynamic drawerPosition) {
        if (drawerPosition.isNull()) {
            view.setDrawerPosition(0x800003);
        } else if (drawerPosition.getType() == ReadableType.Number) {
            int drawerPositionNum = drawerPosition.asInt();
            if (0x800003 == drawerPositionNum || 0x800005 == drawerPositionNum) {
                view.setDrawerPosition(drawerPositionNum);
            } else {
                FLog.w((String)"ReactNative", (String)("Unknown drawerPosition " + drawerPositionNum));
                view.setDrawerPosition(0x800003);
            }
        } else if (drawerPosition.getType() == ReadableType.String) {
            this.setDrawerPositionInternal(view, drawerPosition.asString());
        } else {
            FLog.w((String)"ReactNative", (String)"drawerPosition must be a string or int");
            view.setDrawerPosition(0x800003);
        }
    }

    private void setDrawerPositionInternal(ReactDrawerLayout view, String drawerPosition) {
        if (drawerPosition.equals("left")) {
            view.setDrawerPosition(0x800003);
        } else if (drawerPosition.equals("right")) {
            view.setDrawerPosition(0x800005);
        } else {
            FLog.w((String)"ReactNative", (String)("drawerPosition must be 'left' or 'right', received" + drawerPosition));
            view.setDrawerPosition(0x800003);
        }
    }

    @ReactProp(name="drawerWidth", defaultFloat=NaNf)
    public void setDrawerWidth(ReactDrawerLayout view, float width) {
        int widthInPx = Float.isNaN(width) ? -1 : Math.round(PixelUtil.toPixelFromDIP(width));
        view.setDrawerWidth(widthInPx);
    }

    @Override
    public void setDrawerWidth(ReactDrawerLayout view, @Nullable Float width) {
        int widthInPx = width == null ? -1 : Math.round(PixelUtil.toPixelFromDIP(width.floatValue()));
        view.setDrawerWidth(widthInPx);
    }

    @Override
    @ReactProp(name="drawerLockMode")
    public void setDrawerLockMode(ReactDrawerLayout view, @Nullable String drawerLockMode) {
        if (drawerLockMode == null || "unlocked".equals(drawerLockMode)) {
            view.setDrawerLockMode(0);
        } else if ("locked-closed".equals(drawerLockMode)) {
            view.setDrawerLockMode(1);
        } else if ("locked-open".equals(drawerLockMode)) {
            view.setDrawerLockMode(2);
        } else {
            FLog.w((String)"ReactNative", (String)("Unknown drawerLockMode " + drawerLockMode));
            view.setDrawerLockMode(0);
        }
    }

    @Override
    public void openDrawer(ReactDrawerLayout view) {
        view.openDrawer();
    }

    @Override
    public void closeDrawer(ReactDrawerLayout view) {
        view.closeDrawer();
    }

    @Override
    @ReactProp(name="keyboardDismissMode")
    public void setKeyboardDismissMode(ReactDrawerLayout view, @Nullable String value) {
    }

    @Override
    @ReactProp(name="drawerBackgroundColor", customType="Color")
    public void setDrawerBackgroundColor(ReactDrawerLayout view, @Nullable Integer value) {
    }

    @Override
    @ReactProp(name="statusBarBackgroundColor", customType="Color")
    public void setStatusBarBackgroundColor(ReactDrawerLayout view, @Nullable Integer value) {
    }

    @Override
    public void setElevation(@NonNull ReactDrawerLayout view, float elevation) {
        view.setDrawerElevation(PixelUtil.toPixelFromDIP(elevation));
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("openDrawer", 1, "closeDrawer", 2);
    }

    @Override
    public void receiveCommand(@NonNull ReactDrawerLayout root, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                root.openDrawer();
                break;
            }
            case 2: {
                root.closeDrawer();
            }
        }
    }

    @Override
    public void receiveCommand(@NonNull ReactDrawerLayout root, String commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case "openDrawer": {
                root.openDrawer();
                break;
            }
            case "closeDrawer": {
                root.closeDrawer();
            }
        }
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        return MapBuilder.of("DrawerPosition", MapBuilder.of("Left", 0x800003, "Right", 0x800005));
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        HashMap<String, Object> baseEventTypeConstants = super.getExportedCustomDirectEventTypeConstants();
        HashMap<String, Object> eventTypeConstants = baseEventTypeConstants == null ? new HashMap<String, Object>() : baseEventTypeConstants;
        eventTypeConstants.putAll(MapBuilder.of("topDrawerSlide", MapBuilder.of("registrationName", "onDrawerSlide"), "topDrawerOpen", MapBuilder.of("registrationName", "onDrawerOpen"), "topDrawerClose", MapBuilder.of("registrationName", "onDrawerClose"), "topDrawerStateChanged", MapBuilder.of("registrationName", "onDrawerStateChanged")));
        return eventTypeConstants;
    }

    @Override
    public void addView(ReactDrawerLayout parent, View child, int index) {
        if (this.getChildCount(parent) >= 2) {
            throw new JSApplicationIllegalArgumentException("The Drawer cannot have more than two children");
        }
        if (index != 0 && index != 1) {
            throw new JSApplicationIllegalArgumentException("The only valid indices for drawer's child are 0 or 1. Got " + index + " instead.");
        }
        parent.addView(child, index);
        parent.setDrawerProperties();
    }

    @Override
    public ViewManagerDelegate<ReactDrawerLayout> getDelegate() {
        return this.mDelegate;
    }

    public static class DrawerEventEmitter
    implements DrawerLayout.DrawerListener {
        private final DrawerLayout mDrawerLayout;
        private final EventDispatcher mEventDispatcher;

        public DrawerEventEmitter(DrawerLayout drawerLayout, EventDispatcher eventDispatcher) {
            this.mDrawerLayout = drawerLayout;
            this.mEventDispatcher = eventDispatcher;
        }

        public void onDrawerSlide(@NonNull View view, float v) {
            this.mEventDispatcher.dispatchEvent(new DrawerSlideEvent(UIManagerHelper.getSurfaceId((View)this.mDrawerLayout), this.mDrawerLayout.getId(), v));
        }

        public void onDrawerOpened(@NonNull View view) {
            this.mEventDispatcher.dispatchEvent(new DrawerOpenedEvent(UIManagerHelper.getSurfaceId((View)this.mDrawerLayout), this.mDrawerLayout.getId()));
        }

        public void onDrawerClosed(@NonNull View view) {
            this.mEventDispatcher.dispatchEvent(new DrawerClosedEvent(UIManagerHelper.getSurfaceId((View)this.mDrawerLayout), this.mDrawerLayout.getId()));
        }

        public void onDrawerStateChanged(int i) {
            this.mEventDispatcher.dispatchEvent(new DrawerStateChangedEvent(UIManagerHelper.getSurfaceId((View)this.mDrawerLayout), this.mDrawerLayout.getId(), i));
        }
    }
}

