/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import android.widget.HorizontalScrollView;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.views.view.ReactViewGroup;

public class ReactHorizontalScrollContainerView
extends ReactViewGroup {
    private int mLayoutDirection;
    private int mLastWidth = 0;
    private Listener rtlListener = null;

    public ReactHorizontalScrollContainerView(Context context) {
        super(context);
        this.mLayoutDirection = I18nUtil.getInstance().isRTL(context) ? 1 : 0;
    }

    @Override
    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        if (this.mLayoutDirection == 1) {
            super.setRemoveClippedSubviews(false);
            return;
        }
        super.setRemoveClippedSubviews(removeClippedSubviews);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        HorizontalScrollView parent = (HorizontalScrollView)this.getParent();
        parent.setClipChildren(false);
        this.setClipChildren(false);
        if (this.mLayoutDirection == 1) {
            int newLeft = 0;
            int width = right - left;
            int newRight = newLeft + width;
            this.setLeftTopRightBottom(newLeft, top, newRight, bottom);
            int offsetX = this.getMeasuredWidth() - this.mLastWidth + parent.getScrollX();
            parent.scrollTo(offsetX, parent.getScrollY());
            this.mLastWidth = this.getMeasuredWidth();
            if (this.rtlListener != null) {
                this.rtlListener.onLayout();
            }
        }
    }

    public int getLastWidth() {
        return this.mLastWidth;
    }

    public void setListener(Listener rtlListener) {
        this.rtlListener = rtlListener;
    }

    public static interface Listener {
        public void onLayout();
    }
}

