/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.OverScroller;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.uimanager.MeasureSpecAssertions;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import com.facebook.react.uimanager.ReactClippingViewGroupHelper;
import com.facebook.react.uimanager.ReactOverflowViewWithInset;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.views.scroll.FpsListener;
import com.facebook.react.views.scroll.MaintainVisibleScrollPositionHelper;
import com.facebook.react.views.scroll.OnScrollDispatchHelper;
import com.facebook.react.views.scroll.ReactScrollViewAccessibilityDelegate;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import com.facebook.react.views.scroll.VelocityHelper;
import com.facebook.react.views.view.ReactViewBackgroundManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ReactHorizontalScrollView
extends HorizontalScrollView
implements ReactClippingViewGroup,
ViewGroup.OnHierarchyChangeListener,
View.OnLayoutChangeListener,
ReactOverflowViewWithInset,
ReactScrollViewHelper.HasScrollState,
ReactScrollViewHelper.HasStateWrapper,
ReactScrollViewHelper.HasFlingAnimator,
ReactScrollViewHelper.HasScrollEventThrottle,
ReactScrollViewHelper.HasSmoothScroll {
    private static boolean DEBUG_MODE = false;
    private static String TAG = ReactHorizontalScrollView.class.getSimpleName();
    private static int NO_SCROLL_POSITION = Integer.MIN_VALUE;
    @Nullable
    private static Field sScrollerField;
    private static boolean sTriedToGetScrollerField;
    private int mScrollXAfterMeasure = NO_SCROLL_POSITION;
    private static final int UNSET_CONTENT_OFFSET = -1;
    private final OnScrollDispatchHelper mOnScrollDispatchHelper = new OnScrollDispatchHelper();
    @Nullable
    private final OverScroller mScroller;
    private final VelocityHelper mVelocityHelper = new VelocityHelper();
    private final Rect mRect = new Rect();
    private final Rect mOverflowInset = new Rect();
    private boolean mActivelyScrolling;
    @Nullable
    private Rect mClippingRect;
    @Nullable
    private String mOverflow = "hidden";
    private boolean mDragging;
    private boolean mPagingEnabled = false;
    @Nullable
    private Runnable mPostTouchRunnable;
    private boolean mRemoveClippedSubviews;
    private boolean mScrollEnabled = true;
    private boolean mSendMomentumEvents;
    @Nullable
    private FpsListener mFpsListener = null;
    @Nullable
    private String mScrollPerfTag;
    @Nullable
    private Drawable mEndBackground;
    private int mEndFillColor = 0;
    private boolean mDisableIntervalMomentum = false;
    private int mSnapInterval = 0;
    @Nullable
    private List<Integer> mSnapOffsets;
    private boolean mSnapToStart = true;
    private boolean mSnapToEnd = true;
    private int mSnapToAlignment = 0;
    private ReactViewBackgroundManager mReactBackgroundManager;
    private boolean mPagedArrowScrolling = false;
    private int pendingContentOffsetX = -1;
    private int pendingContentOffsetY = -1;
    private StateWrapper mStateWrapper = null;
    private final ReactScrollViewHelper.ReactScrollViewScrollState mReactScrollViewScrollState;
    private final ValueAnimator DEFAULT_FLING_ANIMATOR = ObjectAnimator.ofInt((Object)this, (String)"scrollX", (int[])new int[]{0, 0});
    private PointerEvents mPointerEvents = PointerEvents.AUTO;
    private long mLastScrollDispatchTime = 0L;
    private int mScrollEventThrottle = 0;
    @Nullable
    private View mContentView;
    @Nullable
    private MaintainVisibleScrollPositionHelper mMaintainVisibleContentPositionHelper;
    private final Rect mTempRect = new Rect();

    public ReactHorizontalScrollView(Context context) {
        this(context, null);
    }

    public ReactHorizontalScrollView(Context context, @Nullable FpsListener fpsListener) {
        super(context);
        this.mReactBackgroundManager = new ReactViewBackgroundManager((View)this);
        this.mFpsListener = fpsListener;
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)new ReactScrollViewAccessibilityDelegate());
        this.mScroller = this.getOverScrollerFromParent();
        this.mReactScrollViewScrollState = new ReactScrollViewHelper.ReactScrollViewScrollState(I18nUtil.getInstance().isRTL(context) ? 1 : 0);
        this.setOnHierarchyChangeListener(this);
    }

    public boolean getScrollEnabled() {
        return this.mScrollEnabled;
    }

    public boolean canScrollHorizontally(int direction) {
        return this.mScrollEnabled && super.canScrollHorizontally(direction);
    }

    @Nullable
    private OverScroller getOverScrollerFromParent() {
        OverScroller scroller;
        if (!sTriedToGetScrollerField) {
            sTriedToGetScrollerField = true;
            try {
                sScrollerField = HorizontalScrollView.class.getDeclaredField("mScroller");
                sScrollerField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                FLog.w((String)TAG, (String)"Failed to get mScroller field for HorizontalScrollView! This app will exhibit the bounce-back scrolling bug :(");
            }
        }
        if (sScrollerField != null) {
            try {
                Object scrollerValue = sScrollerField.get(this);
                if (scrollerValue instanceof OverScroller) {
                    scroller = (OverScroller)scrollerValue;
                }
                FLog.w((String)TAG, (String)"Failed to cast mScroller field in HorizontalScrollView (probably due to OEM changes to AOSP)! This app will exhibit the bounce-back scrolling bug :(");
                scroller = null;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to get mScroller from HorizontalScrollView!", e);
            }
        } else {
            scroller = null;
        }
        return scroller;
    }

    public void setScrollPerfTag(@Nullable String scrollPerfTag) {
        this.mScrollPerfTag = scrollPerfTag;
    }

    @Override
    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        if (removeClippedSubviews && this.mClippingRect == null) {
            this.mClippingRect = new Rect();
        }
        this.mRemoveClippedSubviews = removeClippedSubviews;
        this.updateClippingRect();
    }

    @Override
    public boolean getRemoveClippedSubviews() {
        return this.mRemoveClippedSubviews;
    }

    public void setDisableIntervalMomentum(boolean disableIntervalMomentum) {
        this.mDisableIntervalMomentum = disableIntervalMomentum;
    }

    public void setSendMomentumEvents(boolean sendMomentumEvents) {
        this.mSendMomentumEvents = sendMomentumEvents;
    }

    public void setScrollEnabled(boolean scrollEnabled) {
        this.mScrollEnabled = scrollEnabled;
    }

    public void setPagingEnabled(boolean pagingEnabled) {
        this.mPagingEnabled = pagingEnabled;
    }

    public void setDecelerationRate(float decelerationRate) {
        this.getReactScrollViewScrollState().setDecelerationRate(decelerationRate);
        if (this.mScroller != null) {
            this.mScroller.setFriction(1.0f - decelerationRate);
        }
    }

    public void abortAnimation() {
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
    }

    public void setSnapInterval(int snapInterval) {
        this.mSnapInterval = snapInterval;
    }

    public void setSnapOffsets(List<Integer> snapOffsets) {
        this.mSnapOffsets = snapOffsets;
    }

    public void setSnapToStart(boolean snapToStart) {
        this.mSnapToStart = snapToStart;
    }

    public void setSnapToEnd(boolean snapToEnd) {
        this.mSnapToEnd = snapToEnd;
    }

    public void setSnapToAlignment(int snapToAlignment) {
        this.mSnapToAlignment = snapToAlignment;
    }

    public void flashScrollIndicators() {
        this.awakenScrollBars();
    }

    public void setOverflow(String overflow) {
        this.mOverflow = overflow;
        this.invalidate();
    }

    public void setMaintainVisibleContentPosition(@Nullable MaintainVisibleScrollPositionHelper.Config config) {
        if (config != null && this.mMaintainVisibleContentPositionHelper == null) {
            this.mMaintainVisibleContentPositionHelper = new MaintainVisibleScrollPositionHelper<ReactHorizontalScrollView>(this, true);
            this.mMaintainVisibleContentPositionHelper.start();
        } else if (config == null && this.mMaintainVisibleContentPositionHelper != null) {
            this.mMaintainVisibleContentPositionHelper.stop();
            this.mMaintainVisibleContentPositionHelper = null;
        }
        if (this.mMaintainVisibleContentPositionHelper != null) {
            this.mMaintainVisibleContentPositionHelper.setConfig(config);
        }
    }

    @Override
    @Nullable
    public String getOverflow() {
        return this.mOverflow;
    }

    @Override
    public void setOverflowInset(int left, int top, int right, int bottom) {
        this.mOverflowInset.set(left, top, right, bottom);
    }

    @Override
    public Rect getOverflowInset() {
        return this.mOverflowInset;
    }

    protected void onDraw(Canvas canvas) {
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"onDraw[%d]", (Object)this.getId());
        }
        this.getDrawingRect(this.mRect);
        switch (this.mOverflow) {
            case "visible": {
                break;
            }
            default: {
                canvas.clipRect(this.mRect);
            }
        }
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecAssertions.assertExplicitMeasureSpec(widthMeasureSpec, heightMeasureSpec);
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measuredHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"onMeasure[%d] measured width: %d measured height: %d", (Object)this.getId(), (Object)measuredWidth, (Object)measuredHeight);
        }
        boolean measuredHeightChanged = this.getMeasuredHeight() != measuredHeight;
        this.setMeasuredDimension(measuredWidth, measuredHeight);
        if (measuredHeightChanged && this.mScroller != null) {
            this.mScrollXAfterMeasure = this.mScroller.getCurrX();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"onLayout[%d] l %d t %d r %d b %d", (Object[])new Object[]{this.getId(), l, t, r, b});
        }
        if (this.mScrollXAfterMeasure != NO_SCROLL_POSITION && this.mScroller != null && this.mScrollXAfterMeasure != this.mScroller.getFinalX() && !this.mScroller.isFinished()) {
            if (DEBUG_MODE) {
                FLog.i((String)TAG, (String)"onLayout[%d] scroll hack enabled: reset to previous scrollX position of %d", (Object)this.getId(), (Object)this.mScrollXAfterMeasure);
            }
            this.mScroller.startScroll(this.mScrollXAfterMeasure, this.mScroller.getFinalY(), 0, 0);
            this.mScroller.forceFinished(true);
            this.mScrollXAfterMeasure = NO_SCROLL_POSITION;
        }
        if (this.isContentReady()) {
            int scrollToX = this.pendingContentOffsetX != -1 ? this.pendingContentOffsetX : this.getScrollX();
            int scrollToY = this.pendingContentOffsetY != -1 ? this.pendingContentOffsetY : this.getScrollY();
            this.scrollTo(scrollToX, scrollToY);
        }
        ReactScrollViewHelper.emitLayoutEvent((ViewGroup)this);
    }

    public void requestChildFocus(View child, View focused) {
        if (focused != null && !this.mPagingEnabled) {
            this.scrollToChild(focused);
        }
        super.requestChildFocus(child, focused);
    }

    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        if (this.mPagingEnabled && !this.mPagedArrowScrolling) {
            ArrayList candidateViews = new ArrayList();
            super.addFocusables(candidateViews, direction, focusableMode);
            for (View candidate : candidateViews) {
                if (!this.isScrolledInView(candidate) && !this.isPartiallyScrolledInView(candidate) && !candidate.isFocused()) continue;
                views.add(candidate);
            }
        } else {
            super.addFocusables(views, direction, focusableMode);
        }
    }

    private int getScrollDelta(View descendent) {
        descendent.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(descendent, this.mTempRect);
        return this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
    }

    protected int computeScrollDeltaToGetChildRectOnScreen(Rect rect) {
        if (!this.mScrollEnabled) {
            return 0;
        }
        return super.computeScrollDeltaToGetChildRectOnScreen(rect);
    }

    private boolean isScrolledInView(View descendent) {
        return this.getScrollDelta(descendent) == 0;
    }

    public boolean isPartiallyScrolledInView(View descendent) {
        int scrollDelta = this.getScrollDelta(descendent);
        descendent.getDrawingRect(this.mTempRect);
        return scrollDelta != 0 && Math.abs(scrollDelta) < this.mTempRect.width();
    }

    private boolean isMostlyScrolledInView(View descendent) {
        int scrollDelta = this.getScrollDelta(descendent);
        descendent.getDrawingRect(this.mTempRect);
        return scrollDelta != 0 && Math.abs(scrollDelta) < this.mTempRect.width() / 2;
    }

    private void scrollToChild(View child) {
        int scrollDelta = this.getScrollDelta(child);
        if (scrollDelta != 0) {
            this.scrollBy(scrollDelta, 0);
        }
    }

    protected void onScrollChanged(int x, int y, int oldX, int oldY) {
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"onScrollChanged[%d] x %d y %d oldx %d oldy %d", (Object[])new Object[]{this.getId(), x, y, oldX, oldY});
        }
        super.onScrollChanged(x, y, oldX, oldY);
        this.mActivelyScrolling = true;
        if (this.mOnScrollDispatchHelper.onScrollChanged(x, y)) {
            if (this.mRemoveClippedSubviews) {
                this.updateClippingRect();
            }
            ReactScrollViewHelper.updateStateOnScrollChanged(this, this.mOnScrollDispatchHelper.getXFlingVelocity(), this.mOnScrollDispatchHelper.getYFlingVelocity());
        }
    }

    @Nullable
    private static HorizontalScrollView findDeepestScrollViewForMotionEvent(View view, MotionEvent ev) {
        return ReactHorizontalScrollView.findDeepestScrollViewForMotionEvent(view, ev, true);
    }

    @Nullable
    private static HorizontalScrollView findDeepestScrollViewForMotionEvent(View view, MotionEvent ev, boolean skipInitialView) {
        if (view == null) {
            return null;
        }
        Rect rectOnScreen = new Rect();
        view.getGlobalVisibleRect(rectOnScreen);
        if (!rectOnScreen.contains((int)ev.getRawX(), (int)ev.getRawY())) {
            return null;
        }
        if (!skipInitialView && view instanceof HorizontalScrollView && ViewCompat.isNestedScrollingEnabled((View)view) && view instanceof ReactHorizontalScrollView && ((ReactHorizontalScrollView)view).mScrollEnabled) {
            return (HorizontalScrollView)view;
        }
        if (view instanceof ViewGroup) {
            for (int i = 0; i < ((ViewGroup)view).getChildCount(); ++i) {
                HorizontalScrollView foundScrollView = ReactHorizontalScrollView.findDeepestScrollViewForMotionEvent(((ViewGroup)view).getChildAt(i), ev, false);
                if (foundScrollView == null) continue;
                return foundScrollView;
            }
        }
        return null;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        if (ev.getAction() == 0 && ReactHorizontalScrollView.findDeepestScrollViewForMotionEvent((View)this, ev) != null) {
            return false;
        }
        if (!PointerEvents.canChildrenBeTouchTarget(this.mPointerEvents)) {
            return true;
        }
        try {
            if (super.onInterceptTouchEvent(ev)) {
                this.handleInterceptedTouchEvent(ev);
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            FLog.w((String)"ReactNative", (String)"Error intercepting touch event.", (Throwable)e);
        }
        return false;
    }

    protected void handleInterceptedTouchEvent(MotionEvent ev) {
        NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
        ReactScrollViewHelper.emitScrollBeginDragEvent(this);
        this.mDragging = true;
        this.enableFpsListener();
        this.getFlingAnimator().cancel();
    }

    public boolean pageScroll(int direction) {
        boolean handled = super.pageScroll(direction);
        if (this.mPagingEnabled && handled) {
            this.handlePostTouchScrolling(0, 0);
        }
        return handled;
    }

    public boolean arrowScroll(int direction) {
        boolean handled = false;
        if (this.mPagingEnabled) {
            this.mPagedArrowScrolling = true;
            if (this.getChildCount() > 0) {
                View currentFocused = this.findFocus();
                View nextFocused = FocusFinder.getInstance().findNextFocus((ViewGroup)this, currentFocused, direction);
                View rootChild = this.getContentView();
                if (rootChild != null && nextFocused != null && nextFocused.getParent() == rootChild) {
                    if (!this.isScrolledInView(nextFocused) && !this.isMostlyScrolledInView(nextFocused)) {
                        this.smoothScrollToNextPage(direction);
                    }
                    nextFocused.requestFocus();
                    handled = true;
                } else {
                    this.smoothScrollToNextPage(direction);
                    handled = true;
                }
            }
            this.mPagedArrowScrolling = false;
        } else {
            handled = super.arrowScroll(direction);
        }
        return handled;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mScrollEnabled) {
            return false;
        }
        if (!PointerEvents.canBeTouchTarget(this.mPointerEvents)) {
            return false;
        }
        this.mVelocityHelper.calculateVelocity(ev);
        int action = ev.getActionMasked();
        if (action == 1 && this.mDragging) {
            ReactScrollViewHelper.updateFabricScrollState(this);
            float velocityX = this.mVelocityHelper.getXVelocity();
            float velocityY = this.mVelocityHelper.getYVelocity();
            ReactScrollViewHelper.emitScrollEndDragEvent(this, velocityX, velocityY);
            NativeGestureUtil.notifyNativeGestureEnded((View)this, ev);
            this.mDragging = false;
            this.handlePostTouchScrolling(Math.round(velocityX), Math.round(velocityY));
        }
        if (action == 0) {
            this.cancelPostTouchScrolling();
        }
        return super.onTouchEvent(ev);
    }

    public boolean dispatchGenericPointerEvent(MotionEvent ev) {
        if (!PointerEvents.canChildrenBeTouchTarget(this.mPointerEvents)) {
            return false;
        }
        return super.dispatchGenericPointerEvent(ev);
    }

    public boolean executeKeyEvent(KeyEvent event) {
        int eventKeyCode = event.getKeyCode();
        if (!(this.mScrollEnabled || eventKeyCode != 21 && eventKeyCode != 22)) {
            return false;
        }
        return super.executeKeyEvent(event);
    }

    public void fling(int velocityX) {
        int correctedVelocityX;
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"fling[%d] velocityX %d", (Object)this.getId(), (Object)velocityX);
        }
        int n = correctedVelocityX = Build.VERSION.SDK_INT == 28 ? (int)((float)Math.abs(velocityX) * Math.signum(this.mOnScrollDispatchHelper.getXFlingVelocity())) : velocityX;
        if (this.mPagingEnabled) {
            this.flingAndSnap(correctedVelocityX);
        } else if (this.mScroller != null) {
            int scrollWindowWidth = this.getWidth() - ViewCompat.getPaddingStart((View)this) - ViewCompat.getPaddingEnd((View)this);
            this.mScroller.fling(this.getScrollX(), this.getScrollY(), correctedVelocityX, 0, 0, Integer.MAX_VALUE, 0, 0, scrollWindowWidth / 2, 0);
            ViewCompat.postInvalidateOnAnimation((View)this);
        } else {
            super.fling(correctedVelocityX);
        }
        this.handlePostTouchScrolling(correctedVelocityX, 0);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
        if (this.mMaintainVisibleContentPositionHelper != null) {
            this.mMaintainVisibleContentPositionHelper.start();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mMaintainVisibleContentPositionHelper != null) {
            this.mMaintainVisibleContentPositionHelper.stop();
        }
    }

    @Override
    public void updateClippingRect() {
        if (!this.mRemoveClippedSubviews) {
            return;
        }
        Assertions.assertNotNull((Object)this.mClippingRect);
        ReactClippingViewGroupHelper.calculateClippingRect((View)this, this.mClippingRect);
        View contentView = this.getContentView();
        if (contentView instanceof ReactClippingViewGroup) {
            ((ReactClippingViewGroup)contentView).updateClippingRect();
        }
    }

    @Override
    public void getClippingRect(Rect outClippingRect) {
        outClippingRect.set((Rect)Assertions.assertNotNull((Object)this.mClippingRect));
    }

    public boolean getChildVisibleRect(View child, Rect r, Point offset) {
        return super.getChildVisibleRect(child, r, offset);
    }

    private int getSnapInterval() {
        if (this.mSnapInterval != 0) {
            return this.mSnapInterval;
        }
        return this.getWidth();
    }

    private View getContentView() {
        return this.getChildAt(0);
    }

    public void setEndFillColor(int color) {
        if (color != this.mEndFillColor) {
            this.mEndFillColor = color;
            this.mEndBackground = new ColorDrawable(this.mEndFillColor);
        }
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        int scrollRange;
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"onOverScrolled[%d] scrollX %d scrollY %d clampedX %b clampedY %b", (Object[])new Object[]{this.getId(), scrollX, scrollY, clampedX, clampedY});
        }
        if (this.mScroller != null && !this.mScroller.isFinished() && this.mScroller.getCurrX() != this.mScroller.getFinalX() && scrollX >= (scrollRange = Math.max(this.computeHorizontalScrollRange() - this.getWidth(), 0))) {
            this.mScroller.abortAnimation();
            scrollX = scrollRange;
        }
        super.onOverScrolled(scrollX, scrollY, clampedX, clampedY);
    }

    public void onChildViewAdded(View parent, View child) {
        this.mContentView = child;
        this.mContentView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
    }

    public void onChildViewRemoved(View parent, View child) {
        this.mContentView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        this.mContentView = null;
    }

    private void enableFpsListener() {
        if (this.isScrollPerfLoggingEnabled()) {
            Assertions.assertNotNull((Object)this.mFpsListener);
            Assertions.assertNotNull((Object)this.mScrollPerfTag);
            this.mFpsListener.enable(this.mScrollPerfTag);
        }
    }

    private void disableFpsListener() {
        if (this.isScrollPerfLoggingEnabled()) {
            Assertions.assertNotNull((Object)this.mFpsListener);
            Assertions.assertNotNull((Object)this.mScrollPerfTag);
            this.mFpsListener.disable(this.mScrollPerfTag);
        }
    }

    private boolean isScrollPerfLoggingEnabled() {
        return this.mFpsListener != null && this.mScrollPerfTag != null && !this.mScrollPerfTag.isEmpty();
    }

    public void draw(Canvas canvas) {
        if (this.mEndFillColor != 0) {
            View content = this.getContentView();
            if (this.mEndBackground != null && content != null && content.getRight() < this.getWidth()) {
                this.mEndBackground.setBounds(content.getRight(), 0, this.getWidth(), this.getHeight());
                this.mEndBackground.draw(canvas);
            }
        }
        super.draw(canvas);
    }

    private void handlePostTouchScrolling(int velocityX, int velocityY) {
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"handlePostTouchScrolling[%d] velocityX %d velocityY %d", (Object)this.getId(), (Object)velocityX, (Object)velocityY);
        }
        if (this.mPostTouchRunnable != null) {
            return;
        }
        if (this.mSendMomentumEvents) {
            ReactScrollViewHelper.emitScrollMomentumBeginEvent(this, velocityX, velocityY);
        }
        this.mActivelyScrolling = false;
        this.mPostTouchRunnable = new Runnable(){
            private boolean mSnappingToPage = false;
            private int mStableFrames = 0;

            @Override
            public void run() {
                if (ReactHorizontalScrollView.this.mActivelyScrolling) {
                    ReactHorizontalScrollView.this.mActivelyScrolling = false;
                    this.mStableFrames = 0;
                    ViewCompat.postOnAnimationDelayed((View)ReactHorizontalScrollView.this, (Runnable)this, (long)20L);
                } else {
                    ReactScrollViewHelper.updateFabricScrollState(ReactHorizontalScrollView.this);
                    ++this.mStableFrames;
                    if (this.mStableFrames >= 3) {
                        ReactHorizontalScrollView.this.mPostTouchRunnable = null;
                        if (ReactHorizontalScrollView.this.mSendMomentumEvents) {
                            ReactScrollViewHelper.emitScrollMomentumEndEvent(ReactHorizontalScrollView.this);
                        }
                        ReactHorizontalScrollView.this.disableFpsListener();
                    } else {
                        if (ReactHorizontalScrollView.this.mPagingEnabled && !this.mSnappingToPage) {
                            this.mSnappingToPage = true;
                            ReactHorizontalScrollView.this.flingAndSnap(0);
                        }
                        ViewCompat.postOnAnimationDelayed((View)ReactHorizontalScrollView.this, (Runnable)this, (long)20L);
                    }
                }
            }
        };
        ViewCompat.postOnAnimationDelayed((View)this, (Runnable)this.mPostTouchRunnable, (long)20L);
    }

    private void cancelPostTouchScrolling() {
        if (this.mPostTouchRunnable != null) {
            this.removeCallbacks(this.mPostTouchRunnable);
            this.mPostTouchRunnable = null;
            this.getFlingAnimator().cancel();
        }
    }

    private int predictFinalScrollPosition(int velocityX) {
        int maximumOffset = Math.max(0, this.computeHorizontalScrollRange() - this.getWidth());
        return this.getFlingAnimator() == this.DEFAULT_FLING_ANIMATOR ? ReactScrollViewHelper.predictFinalScrollPosition(this, (int)velocityX, (int)0, (int)maximumOffset, (int)0).x : ReactScrollViewHelper.getNextFlingStartValue(this, this.getScrollX(), this.getReactScrollViewScrollState().getFinalAnimatedPositionScroll().x, velocityX) + this.getFlingExtrapolatedDistance(velocityX);
    }

    private void smoothScrollAndSnap(int velocity) {
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"smoothScrollAndSnap[%d] velocity %d", (Object)this.getId(), (Object)velocity);
        }
        double interval = this.getSnapInterval();
        double currentOffset = ReactScrollViewHelper.getNextFlingStartValue(this, this.getScrollX(), this.getReactScrollViewScrollState().getFinalAnimatedPositionScroll().x, velocity);
        double targetOffset = this.predictFinalScrollPosition(velocity);
        int previousPage = (int)Math.floor(currentOffset / interval);
        int nextPage = (int)Math.ceil(currentOffset / interval);
        int currentPage = (int)Math.round(currentOffset / interval);
        int targetPage = (int)Math.round(targetOffset / interval);
        if (velocity > 0 && nextPage == previousPage) {
            ++nextPage;
        } else if (velocity < 0 && previousPage == nextPage) {
            --previousPage;
        }
        if (velocity > 0 && currentPage < nextPage && targetPage > previousPage) {
            currentPage = nextPage;
        } else if (velocity < 0 && currentPage > previousPage && targetPage < nextPage) {
            currentPage = previousPage;
        }
        targetOffset = (double)currentPage * interval;
        if (targetOffset != currentOffset) {
            this.mActivelyScrolling = true;
            this.reactSmoothScrollTo((int)targetOffset, this.getScrollY());
        }
    }

    private void flingAndSnap(int velocityX) {
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"smoothScrollAndSnap[%d] velocityX %d", (Object)this.getId(), (Object)velocityX);
        }
        if (this.getChildCount() <= 0) {
            return;
        }
        if (this.mSnapInterval == 0 && this.mSnapOffsets == null && this.mSnapToAlignment == 0) {
            this.smoothScrollAndSnap(velocityX);
            return;
        }
        boolean hasCustomizedFlingAnimator = this.getFlingAnimator() != this.DEFAULT_FLING_ANIMATOR;
        int maximumOffset = Math.max(0, this.computeHorizontalScrollRange() - this.getWidth());
        int targetOffset = this.predictFinalScrollPosition(velocityX);
        if (this.mDisableIntervalMomentum) {
            targetOffset = this.getScrollX();
        }
        int smallerOffset = 0;
        int largerOffset = maximumOffset;
        int firstOffset = 0;
        int lastOffset = maximumOffset;
        int width = this.getWidth() - ViewCompat.getPaddingStart((View)this) - ViewCompat.getPaddingEnd((View)this);
        int layoutDirection = this.getReactScrollViewScrollState().getLayoutDirection();
        if (layoutDirection == 1) {
            targetOffset = maximumOffset - targetOffset;
            velocityX = -velocityX;
        }
        if (this.mSnapOffsets != null && !this.mSnapOffsets.isEmpty()) {
            firstOffset = this.mSnapOffsets.get(0);
            lastOffset = this.mSnapOffsets.get(this.mSnapOffsets.size() - 1);
            for (int i = 0; i < this.mSnapOffsets.size(); ++i) {
                int offset = this.mSnapOffsets.get(i);
                if (offset <= targetOffset && targetOffset - offset < targetOffset - smallerOffset) {
                    smallerOffset = offset;
                }
                if (offset < targetOffset || offset - targetOffset >= largerOffset - targetOffset) continue;
                largerOffset = offset;
            }
        } else if (this.mSnapToAlignment != 0) {
            if (this.mSnapInterval > 0) {
                double ratio = (double)targetOffset / (double)this.mSnapInterval;
                smallerOffset = Math.max(this.getItemStartOffset(this.mSnapToAlignment, (int)(Math.floor(ratio) * (double)this.mSnapInterval), this.mSnapInterval, width), 0);
                largerOffset = Math.min(this.getItemStartOffset(this.mSnapToAlignment, (int)(Math.ceil(ratio) * (double)this.mSnapInterval), this.mSnapInterval, width), maximumOffset);
            } else {
                ViewGroup contentView = (ViewGroup)this.getContentView();
                int smallerChildOffset = largerOffset;
                int largerChildOffset = smallerOffset;
                for (int i = 0; i < contentView.getChildCount(); ++i) {
                    View item = contentView.getChildAt(i);
                    int itemStartOffset = this.getItemStartOffset(this.mSnapToAlignment, item.getLeft(), item.getWidth(), width);
                    if (itemStartOffset <= targetOffset && targetOffset - itemStartOffset < targetOffset - smallerOffset) {
                        smallerOffset = itemStartOffset;
                    }
                    if (itemStartOffset >= targetOffset && itemStartOffset - targetOffset < largerOffset - targetOffset) {
                        largerOffset = itemStartOffset;
                    }
                    smallerChildOffset = Math.min(smallerChildOffset, itemStartOffset);
                    largerChildOffset = Math.max(largerChildOffset, itemStartOffset);
                }
                smallerOffset = Math.max(smallerOffset, smallerChildOffset);
                largerOffset = Math.min(largerOffset, largerChildOffset);
            }
        } else {
            double interval = this.getSnapInterval();
            double ratio = (double)targetOffset / interval;
            smallerOffset = (int)(Math.floor(ratio) * interval);
            largerOffset = Math.min((int)(Math.ceil(ratio) * interval), maximumOffset);
        }
        int nearestOffset = Math.abs(targetOffset - smallerOffset) < Math.abs(largerOffset - targetOffset) ? smallerOffset : largerOffset;
        int currentOffset = this.getScrollX();
        if (layoutDirection == 1) {
            currentOffset = maximumOffset - currentOffset;
        }
        if (!this.mSnapToEnd && targetOffset >= lastOffset) {
            if (currentOffset < lastOffset) {
                targetOffset = lastOffset;
            }
        } else if (!this.mSnapToStart && targetOffset <= firstOffset) {
            if (currentOffset > firstOffset) {
                targetOffset = firstOffset;
            }
        } else if (velocityX > 0) {
            if (!hasCustomizedFlingAnimator) {
                velocityX += (int)((double)(largerOffset - targetOffset) * 10.0);
            }
            targetOffset = largerOffset;
        } else if (velocityX < 0) {
            if (!hasCustomizedFlingAnimator) {
                velocityX -= (int)((double)(targetOffset - smallerOffset) * 10.0);
            }
            targetOffset = smallerOffset;
        } else {
            targetOffset = nearestOffset;
        }
        targetOffset = Math.min(Math.max(0, targetOffset), maximumOffset);
        if (layoutDirection == 1) {
            targetOffset = maximumOffset - targetOffset;
            velocityX = -velocityX;
        }
        if (hasCustomizedFlingAnimator || this.mScroller == null) {
            this.reactSmoothScrollTo(targetOffset, this.getScrollY());
        } else {
            this.mActivelyScrolling = true;
            this.mScroller.fling(this.getScrollX(), this.getScrollY(), velocityX != 0 ? velocityX : targetOffset - this.getScrollX(), 0, targetOffset, targetOffset, 0, 0, targetOffset == 0 || targetOffset == maximumOffset ? width / 2 : 0, 0);
            this.postInvalidateOnAnimation();
        }
    }

    private int getItemStartOffset(int snapToAlignment, int itemStartPosition, int itemWidth, int viewPortWidth) {
        return switch (snapToAlignment) {
            case 2 -> itemStartPosition - (viewPortWidth - itemWidth) / 2;
            case 1 -> itemStartPosition;
            case 3 -> itemStartPosition - (viewPortWidth - itemWidth);
            default -> throw new IllegalStateException("Invalid SnapToAlignment value: " + this.mSnapToAlignment);
        };
    }

    private void smoothScrollToNextPage(int direction) {
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"smoothScrollToNextPage[%d] direction %d", (Object)this.getId(), (Object)direction);
        }
        int width = this.getWidth();
        int currentX = this.getScrollX();
        int page = currentX / width;
        if (currentX % width != 0) {
            ++page;
        }
        page = direction == 17 ? --page : ++page;
        if (page < 0) {
            page = 0;
        }
        this.reactSmoothScrollTo(page * width, this.getScrollY());
        this.handlePostTouchScrolling(0, 0);
    }

    public void setBackgroundColor(int color) {
        this.mReactBackgroundManager.setBackgroundColor(color);
    }

    public void setBorderWidth(int position, float width) {
        this.mReactBackgroundManager.setBorderWidth(position, width);
    }

    public void setBorderColor(int position, float color, float alpha) {
        this.mReactBackgroundManager.setBorderColor(position, color, alpha);
    }

    public void setBorderRadius(float borderRadius) {
        this.mReactBackgroundManager.setBorderRadius(borderRadius);
    }

    public void setBorderRadius(float borderRadius, int position) {
        this.mReactBackgroundManager.setBorderRadius(borderRadius, position);
    }

    public void setBorderStyle(@Nullable String style2) {
        this.mReactBackgroundManager.setBorderStyle(style2);
    }

    @Override
    public void reactSmoothScrollTo(int x, int y) {
        ReactScrollViewHelper.smoothScrollTo(this, x, y);
        this.setPendingContentOffsets(x, y);
    }

    public void scrollTo(int x, int y) {
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"scrollTo[%d] x %d y %d", (Object)this.getId(), (Object)x, (Object)y);
        }
        super.scrollTo(x, y);
        ReactScrollViewHelper.updateFabricScrollState(this);
        this.setPendingContentOffsets(x, y);
    }

    private boolean isContentReady() {
        View child = this.getContentView();
        return child != null && child.getWidth() != 0 && child.getHeight() != 0;
    }

    private void setPendingContentOffsets(int x, int y) {
        if (DEBUG_MODE) {
            FLog.i((String)TAG, (String)"setPendingContentOffsets[%d] x %d y %d", (Object)this.getId(), (Object)x, (Object)y);
        }
        if (this.isContentReady()) {
            this.pendingContentOffsetX = -1;
            this.pendingContentOffsetY = -1;
        } else {
            this.pendingContentOffsetX = x;
            this.pendingContentOffsetY = y;
        }
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (this.mContentView == null) {
            return;
        }
        if (this.mReactScrollViewScrollState.getLayoutDirection() == 1) {
            this.adjustPositionForContentChangeRTL(left, right, oldLeft, oldRight);
        } else if (this.mMaintainVisibleContentPositionHelper != null) {
            this.mMaintainVisibleContentPositionHelper.updateScrollPosition();
        }
    }

    private void adjustPositionForContentChangeRTL(int left, int right, int oldLeft, int oldRight) {
        if (this.getFlingAnimator().isRunning()) {
            this.getFlingAnimator().end();
        }
        int distanceToRightEdge = oldRight - this.getScrollX();
        int newWidth = right - left;
        int scrollX = newWidth - distanceToRightEdge;
        this.scrollTo(scrollX, this.getScrollY());
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            int scrollerXBeforeTick = this.mScroller.getCurrX();
            boolean hasMoreTicks = this.mScroller.computeScrollOffset();
            this.mScroller.forceFinished(true);
            if (hasMoreTicks) {
                float direction = Math.signum(this.mScroller.getFinalX() - this.mScroller.getStartX());
                float flingVelocityX = this.mScroller.getCurrVelocity() * direction;
                this.mScroller.fling(scrollX, this.getScrollY(), (int)flingVelocityX, 0, 0, newWidth - this.getWidth(), 0, 0);
            } else {
                this.scrollTo(scrollX + (this.mScroller.getCurrX() - scrollerXBeforeTick), this.getScrollY());
            }
        }
    }

    @Override
    @Nullable
    public StateWrapper getStateWrapper() {
        return this.mStateWrapper;
    }

    public void setStateWrapper(StateWrapper stateWrapper) {
        this.mStateWrapper = stateWrapper;
    }

    @Override
    public ReactScrollViewHelper.ReactScrollViewScrollState getReactScrollViewScrollState() {
        return this.mReactScrollViewScrollState;
    }

    @Override
    public void startFlingAnimator(int start, int end) {
        this.DEFAULT_FLING_ANIMATOR.cancel();
        this.DEFAULT_FLING_ANIMATOR.setDuration((long)ReactScrollViewHelper.getDefaultScrollAnimationDuration(this.getContext())).setIntValues(new int[]{start, end});
        this.DEFAULT_FLING_ANIMATOR.start();
    }

    @Override
    public ValueAnimator getFlingAnimator() {
        return this.DEFAULT_FLING_ANIMATOR;
    }

    @Override
    public int getFlingExtrapolatedDistance(int velocityX) {
        return ReactScrollViewHelper.predictFinalScrollPosition(this, (int)velocityX, (int)0, (int)Math.max((int)0, (int)(this.computeHorizontalScrollRange() - this.getWidth())), (int)0).x;
    }

    public void setPointerEvents(PointerEvents pointerEvents) {
        this.mPointerEvents = pointerEvents;
    }

    public PointerEvents getPointerEvents() {
        return this.mPointerEvents;
    }

    @Override
    public void setScrollEventThrottle(int scrollEventThrottle) {
        this.mScrollEventThrottle = scrollEventThrottle;
    }

    @Override
    public int getScrollEventThrottle() {
        return this.mScrollEventThrottle;
    }

    @Override
    public void setLastScrollDispatchTime(long lastScrollDispatchTime) {
        this.mLastScrollDispatchTime = lastScrollDispatchTime;
    }

    @Override
    public long getLastScrollDispatchTime() {
        return this.mLastScrollDispatchTime;
    }

    static {
        sTriedToGetScrollerField = false;
    }
}

