/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkModuleDecoder;
import com.reandroid.apk.ResFile;
import com.reandroid.apk.SplitJsonResourceDecoder;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.AndroidManifestBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.json.JSONObject;
import java.io.File;
import java.io.IOException;

public class ApkModuleJsonDecoder
extends ApkModuleDecoder {
    private final boolean splitTypes;

    public ApkModuleJsonDecoder(ApkModule apkModule, boolean splitTypes) {
        super(apkModule);
        this.splitTypes = splitTypes;
    }

    public ApkModuleJsonDecoder(ApkModule apkModule) {
        this(apkModule, false);
    }

    @Override
    public void decodeResourceTable(File mainDirectory) throws IOException {
        this.decodeTable(mainDirectory);
        this.decodeResFiles(mainDirectory);
    }

    private void decodeResFiles(File mainDirectory) throws IOException {
        ApkModule apkModule = this.getApkModule();
        this.logMessage("Decoding res files ...");
        for (ResFile resFile : apkModule.listResFiles()) {
            this.decodeResFile(mainDirectory, resFile);
        }
    }

    private void decodeResFile(File mainDirectory, ResFile resFile) throws IOException {
        if (resFile.isBinaryXml()) {
            this.decodeResFileXml(mainDirectory, resFile);
        }
    }

    private void decodeResFileXml(File mainDirectory, ResFile resFile) throws IOException {
        InputSource inputSource = resFile.getInputSource();
        String path = inputSource.getAlias();
        this.logVerbose(path);
        File file = this.toResJson(mainDirectory, path);
        ResXmlDocument resXmlDocument = new ResXmlDocument();
        resXmlDocument.readBytes(inputSource.openStream());
        JSONObject jsonObject = resXmlDocument.toJson();
        jsonObject.write(file);
        this.addDecodedPath(path);
    }

    private void decodeTable(File dir) throws IOException {
        if (!this.splitTypes) {
            this.writeTableSingle(dir);
            return;
        }
        this.writeTableSplit(dir);
    }

    private void writeTableSplit(File dir) throws IOException {
        ApkModule apkModule = this.getApkModule();
        if (!apkModule.hasTableBlock()) {
            return;
        }
        TableBlock tableBlock = apkModule.getTableBlock();
        File resourcesDir = new File(dir, TableBlock.DIRECTORY_NAME);
        SplitJsonResourceDecoder splitJsonResourceDecoder = new SplitJsonResourceDecoder(tableBlock);
        splitJsonResourceDecoder.decodeSplitJsonFiles(resourcesDir);
        this.addDecodedPath(TableBlock.FILE_NAME);
    }

    private void writeTableSingle(File mainDirectory) throws IOException {
        ApkModule apkModule = this.getApkModule();
        if (!apkModule.hasTableBlock()) {
            return;
        }
        TableBlock tableBlock = apkModule.getTableBlock();
        File file = new File(mainDirectory, TableBlock.DIRECTORY_NAME);
        file = new File(file, TableBlock.FILE_NAME_JSON);
        tableBlock.toJson().write(file);
        this.addDecodedPath(TableBlock.FILE_NAME);
    }

    @Override
    void decodeAndroidManifest(File mainDirectory) throws IOException {
        ApkModule apkModule = this.getApkModule();
        if (!apkModule.hasAndroidManifest()) {
            return;
        }
        AndroidManifestBlock manifest = apkModule.getAndroidManifest();
        File file = new File(mainDirectory, AndroidManifestBlock.FILE_NAME_JSON);
        manifest.toJson().write(file);
        this.addDecodedPath(AndroidManifestBlock.FILE_NAME);
    }

    private File toResJson(File mainDirectory, String path) {
        File file = new File(mainDirectory, TableBlock.RES_JSON_DIRECTORY_NAME);
        path = path + ".json";
        path = path.replace('/', File.separatorChar);
        return new File(file, path);
    }
}

