/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.arsc.ARSCLib;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.StagedAlias;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.json.JSONObject;
import java.io.File;
import java.io.IOException;

public class SplitJsonResourceDecoder {
    private final TableBlock tableBlock;

    public SplitJsonResourceDecoder(TableBlock tableBlock) {
        this.tableBlock = tableBlock;
    }

    public void decodeSplitJsonFiles(File resourcesDir) throws IOException {
        for (PackageBlock packageBlock : this.tableBlock.listPackages()) {
            this.decodeSplitPackageJson(resourcesDir, packageBlock);
        }
    }

    private void decodeSplitPackageJson(File resourcesDir, PackageBlock packageBlock) throws IOException {
        File packageDir = new File(resourcesDir, packageBlock.buildDecodeDirectoryName());
        this.writeSplitPackageInfoJson(packageDir, packageBlock);
        for (SpecTypePair specTypePair : packageBlock.listSpecTypePairs()) {
            for (TypeBlock typeBlock : specTypePair.getTypeBlockArray().listItems()) {
                this.writeSplitTypeJsonFiles(packageDir, typeBlock);
            }
        }
    }

    private void writeSplitPackageInfoJson(File packageDirectory, PackageBlock packageBlock) throws IOException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("arsc_lib_version", ARSCLib.getVersion());
        jsonObject.put(PackageBlock.NAME_package_id, packageBlock.getId());
        jsonObject.put(PackageBlock.NAME_package_name, packageBlock.getName());
        StagedAlias stagedAlias = StagedAlias.mergeAll(packageBlock.getStagedAliasList().getChildes());
        if (stagedAlias != null) {
            jsonObject.put(PackageBlock.NAME_staged_aliases, stagedAlias.getStagedAliasEntryArray().toJson());
        }
        File packageFile = new File(packageDirectory, PackageBlock.JSON_FILE_NAME);
        jsonObject.write(packageFile);
    }

    private void writeSplitTypeJsonFiles(File packageDirectory, TypeBlock typeBlock) throws IOException {
        File file = new File(packageDirectory, typeBlock.buildUniqueDirectoryName() + ".json");
        JSONObject jsonObject = typeBlock.toJson();
        jsonObject.write(file);
    }
}

