/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk;

import com.reandroid.apk.TableBlockJsonBuilder;
import com.reandroid.archive.BlockInputSource;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.utils.Crc32OutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SplitJsonTableInputSource
extends BlockInputSource<TableBlock> {
    private final File resourcesDirectory;
    private TableBlock mCache;

    public SplitJsonTableInputSource(File resourcesDirectory) {
        super(TableBlock.FILE_NAME, null);
        this.resourcesDirectory = resourcesDirectory;
    }

    @Override
    public TableBlock getBlock() {
        try {
            return this.getTableBlock();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public long write(OutputStream outputStream) throws IOException {
        return this.getTableBlock().writeBytes(outputStream);
    }

    @Override
    public InputStream openStream() throws IOException {
        TableBlock tableBlock = this.getTableBlock();
        return new ByteArrayInputStream(tableBlock.getBytes());
    }

    @Override
    public long getLength() throws IOException {
        TableBlock tableBlock = this.getTableBlock();
        return tableBlock.countBytes();
    }

    @Override
    public long getCrc() throws IOException {
        Crc32OutputStream outputStream = new Crc32OutputStream();
        this.write(outputStream);
        return outputStream.getValue();
    }

    public TableBlock getTableBlock() throws IOException {
        TableBlock tableBlock;
        if (this.mCache != null) {
            return this.mCache;
        }
        TableBlockJsonBuilder builder = new TableBlockJsonBuilder();
        this.mCache = tableBlock = builder.scanDirectory(this.resourcesDirectory);
        return tableBlock;
    }
}

