/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.apk.xmlencoder;

import com.reandroid.apk.APKLogger;
import com.reandroid.apk.ApkModule;
import com.reandroid.apk.ApkUtil;
import com.reandroid.apk.xmlencoder.EncodeUtil;
import com.reandroid.apk.xmlencoder.XMLEncodeSource;
import com.reandroid.archive.FileInputSource;
import com.reandroid.archive.InputSource;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.coder.xml.XmlEncodeException;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.Entry;
import com.reandroid.xml.source.XMLFileParserSource;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class FilePathEncoder {
    private final ApkModule apkModule;
    private APKLogger mLogger;
    private PackageBlock mCurrentPackage;

    public FilePathEncoder(ApkModule apkModule) {
        this.apkModule = apkModule;
        this.mLogger = apkModule.getApkLogger();
    }

    private PackageBlock getCurrentPackage() {
        PackageBlock packageBlock = this.mCurrentPackage;
        if (packageBlock == null) {
            TableBlock tableBlock = this.apkModule.getTableBlock();
            if (tableBlock == null) {
                throw new NullPointerException("TableBlock == null");
            }
            packageBlock = tableBlock.pickOne();
            if (packageBlock == null) {
                throw new NullPointerException("PackageBlock == null");
            }
            this.mCurrentPackage = packageBlock;
        }
        return this.mCurrentPackage;
    }

    public void encodePackageResDir(PackageBlock packageBlock, File resDir) throws IOException {
        this.mCurrentPackage = packageBlock;
        int count = 0;
        String simpleName = resDir.getParentFile().getName() + File.separator + resDir.getName();
        this.logMessage("Scan: " + simpleName);
        List<File> dirList = ApkUtil.listDirectories(resDir);
        for (File dir : dirList) {
            if (ApkUtil.isValuesDirectoryName(dir.getName(), true)) continue;
            count += this.encodeTypeDir(dir);
        }
        this.logMessage("Scanned " + count + " files: " + simpleName);
    }

    public int encodeTypeDir(File dir) throws IOException {
        List<File> fileList = ApkUtil.listFiles(dir, null);
        for (File file : fileList) {
            this.encodeTypeFileEntry(file);
        }
        return fileList.size();
    }

    public void encodeTypeFileEntry(File resFile) throws IOException {
        String type = EncodeUtil.getTypeNameFromResFile(resFile);
        String qualifiers = EncodeUtil.getQualifiersFromResFile(resFile);
        String name = EncodeUtil.getEntryNameFromResFile(resFile);
        String path = EncodeUtil.getEntryPathFromResFile(resFile);
        PackageBlock packageBlock = this.getCurrentPackage();
        ResourceEntry resourceEntry = packageBlock.getTableBlock().getLocalResource(packageBlock, type, name);
        if (resourceEntry == null) {
            throw new XmlEncodeException("Local resource not defined: @" + type + "/" + name + ", for path: " + path);
        }
        Entry entry = resourceEntry.getOrCreate(qualifiers);
        entry.setValueAsString(path);
        InputSource inputSource = this.createInputSource(resourceEntry.getPackageBlock(), path, resFile);
        this.addInputSource(inputSource);
    }

    private InputSource createInputSource(PackageBlock packageBlock, String path, File resFile) {
        if (this.isXmlFile(resFile)) {
            return this.createXMLEncodeInputSource(packageBlock, path, resFile);
        }
        return this.createRawFileInputSource(path, resFile);
    }

    private InputSource createRawFileInputSource(String path, File resFile) {
        FileInputSource inputSource = new FileInputSource(resFile, path);
        inputSource.setMethod(0);
        return inputSource;
    }

    private InputSource createXMLEncodeInputSource(PackageBlock packageBlock, String path, File resFile) {
        XMLFileParserSource xmlSource = new XMLFileParserSource(path, resFile);
        XMLEncodeSource encodeSource = new XMLEncodeSource(packageBlock, xmlSource);
        encodeSource.setApkLogger(this.mLogger);
        return encodeSource;
    }

    private boolean isXmlFile(File resFile) {
        String name = resFile.getName();
        if (!name.endsWith(".xml")) {
            return false;
        }
        String type = EncodeUtil.getTypeNameFromResFile(resFile);
        if (!"raw".equals(type)) {
            return true;
        }
        this.logMessage("WARN: Using un-encoded raw xml: " + resFile);
        return false;
    }

    private void addInputSource(InputSource inputSource) {
        if (inputSource != null) {
            this.apkModule.add(inputSource);
        }
    }

    public void setApkLogger(APKLogger logger) {
        this.mLogger = logger;
    }

    private void logMessage(String msg) {
        APKLogger apkLogger = this.mLogger;
        if (apkLogger != null) {
            apkLogger.logMessage(msg);
        }
    }
}

