/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.apk.APKLogger;
import com.reandroid.archive.ArchiveEntry;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.PathTree;
import com.reandroid.archive.ZipEntryMap;
import com.reandroid.archive.block.ApkSignatureBlock;
import com.reandroid.archive.block.EndRecord;
import com.reandroid.archive.io.ZipInput;
import com.reandroid.archive.model.CentralFileDirectory;
import com.reandroid.archive.model.LocalFileDirectory;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.io.FilePermissions;
import com.reandroid.utils.io.FileUtil;
import com.reandroid.utils.io.IOUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public abstract class Archive<T extends ZipInput>
implements Closeable {
    private final T zipInput;
    private final ArchiveEntry[] entryList;
    private final EndRecord endRecord;
    private final ApkSignatureBlock apkSignatureBlock;
    private static final long LOG_LARGE_FILE_SIZE = 20480000L;
    public static final int STORED = ObjectsUtil.of(0);
    public static final int DEFLATED = ObjectsUtil.of(8);

    public Archive(T zipInput) throws IOException {
        this.zipInput = zipInput;
        CentralFileDirectory cfd = new CentralFileDirectory();
        cfd.visit((ZipInput)zipInput);
        this.endRecord = cfd.getEndRecord();
        LocalFileDirectory lfd = new LocalFileDirectory(cfd);
        lfd.visit((ZipInput)zipInput);
        this.entryList = lfd.buildArchiveEntryList();
        this.apkSignatureBlock = lfd.getApkSigBlock();
    }

    public ZipEntryMap createZipEntryMap() {
        return new ZipEntryMap(this.mapEntrySource());
    }

    public InputSource[] getInputSources() {
        return this.getInputSources(ArchiveEntry::isFile);
    }

    public InputSource[] getInputSources(Predicate<? super ArchiveEntry> filter) {
        Iterator<InputSource> iterator = ComputeIterator.of(this.iterator(filter), this::createInputSource);
        List<InputSource> sourceList = CollectionUtil.toList(iterator);
        return sourceList.toArray(new InputSource[sourceList.size()]);
    }

    public PathTree<InputSource> getPathTree() {
        PathTree<InputSource> root = PathTree.newRoot();
        Iterator<ArchiveEntry> iterator = this.getFiles();
        while (iterator.hasNext()) {
            ArchiveEntry entry = iterator.next();
            InputSource inputSource = this.createInputSource(entry);
            root.add(inputSource.getAlias(), inputSource);
        }
        return root;
    }

    public LinkedHashMap<String, InputSource> mapEntrySource() {
        LinkedHashMap<String, InputSource> map = new LinkedHashMap<String, InputSource>(this.size());
        Iterator<ArchiveEntry> iterator = this.getFiles();
        while (iterator.hasNext()) {
            ArchiveEntry entry = iterator.next();
            InputSource inputSource = this.createInputSource(entry);
            map.put(inputSource.getAlias(), inputSource);
        }
        return map;
    }

    public T getZipInput() {
        return this.zipInput;
    }

    abstract InputSource createInputSource(ArchiveEntry var1);

    public InputSource getEntrySource(String path) {
        if (path == null) {
            return null;
        }
        for (ArchiveEntry entry : this.entryList) {
            if (entry.isDirectory() || !path.equals(entry.getName())) continue;
            return this.createInputSource(entry);
        }
        return null;
    }

    public InputStream openRawInputStream(ArchiveEntry archiveEntry) throws IOException {
        return this.zipInput.getInputStream(archiveEntry.getFileOffset(), archiveEntry.getDataSize());
    }

    public InputStream openInputStream(ArchiveEntry archiveEntry) throws IOException {
        InputStream rawInputStream = this.openRawInputStream(archiveEntry);
        if (!archiveEntry.isCompressed()) {
            return rawInputStream;
        }
        return new InflaterInputStream(rawInputStream, new Inflater(true), 1024000);
    }

    public Iterator<ArchiveEntry> getFiles() {
        return this.iterator(ArchiveEntry::isFile);
    }

    public Iterator<ArchiveEntry> iterator() {
        return new ArrayIterator<ArchiveEntry>(this.entryList);
    }

    public Iterator<ArchiveEntry> iterator(Predicate<? super ArchiveEntry> filter) {
        return new ArrayIterator<ArchiveEntry>(this.entryList, filter);
    }

    public int size() {
        return this.entryList.length;
    }

    public ApkSignatureBlock getApkSignatureBlock() {
        return this.apkSignatureBlock;
    }

    public EndRecord getEndRecord() {
        return this.endRecord;
    }

    public int extractAll(File dir) throws IOException {
        return this.extractAll(dir, null, null);
    }

    public int extractAll(File dir, APKLogger logger) throws IOException {
        return this.extractAll(dir, null, logger);
    }

    public int extractAll(File dir, Predicate<ArchiveEntry> filter) throws IOException {
        return this.extractAll(dir, filter, null);
    }

    public int extractAll(File dir, Predicate<ArchiveEntry> filter, APKLogger logger) throws IOException {
        Iterator<ArchiveEntry> iterator = this.iterator(filter);
        int result = 0;
        while (iterator.hasNext()) {
            ArchiveEntry archiveEntry = iterator.next();
            this.extract(this.toFile(dir, archiveEntry), archiveEntry, logger);
            ++result;
        }
        return result;
    }

    public void extract(File file, ArchiveEntry archiveEntry) throws IOException {
        this.extract(file, archiveEntry, null);
    }

    public void extract(File file, ArchiveEntry archiveEntry, APKLogger logger) throws IOException {
        long size;
        if (archiveEntry.isDirectory()) {
            return;
        }
        FileUtil.ensureParentDirectory(file);
        if (logger != null && (size = archiveEntry.getDataSize()) > 20480000L) {
            logger.logVerbose("Extracting [" + FileUtil.toReadableFileSize(size) + "] " + archiveEntry.getName());
        }
        if (archiveEntry.getMethod() != STORED) {
            this.extractCompressed(file, archiveEntry);
        } else {
            this.extractStored(file, archiveEntry);
        }
        this.applyAttributes(archiveEntry, file);
    }

    private void applyAttributes(ArchiveEntry archiveEntry, File file) {
        FilePermissions permissions = archiveEntry.getFilePermissions();
        if (permissions.get() != 0) {
            permissions.apply(file);
        }
        long time = Archive.dosToJavaDate(archiveEntry.getDosTime()).getTime();
        file.setLastModified(time);
    }

    abstract void extractStored(File var1, ArchiveEntry var2) throws IOException;

    private void extractCompressed(File file, ArchiveEntry archiveEntry) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        IOUtil.writeAll(this.openInputStream(archiveEntry), outputStream);
    }

    private File toFile(File dir, ArchiveEntry archiveEntry) {
        String name = archiveEntry.getName().replace('/', File.separatorChar);
        return new File(dir, name);
    }

    @Override
    public void close() throws IOException {
        this.zipInput.close();
    }

    public static <T1 extends InputSource> PathTree<T1> buildPathTree(T1[] inputSources) {
        PathTree root = PathTree.newRoot();
        for (T1 item : inputSources) {
            root.add(((InputSource)item).getAlias(), item);
        }
        return root;
    }

    public static Date dosToJavaDate(long dosTime) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, (int)(dosTime >> 25 & 0x7FL) + 1980);
        cal.set(2, (int)(dosTime >> 21 & 0xFL) - 1);
        cal.set(5, (int)(dosTime >> 16) & 0x1F);
        cal.set(11, (int)(dosTime >> 11) & 0x1F);
        cal.set(12, (int)(dosTime >> 5) & 0x3F);
        cal.set(13, (int)(dosTime << 1) & 0x3E);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static long javaToDosTime(long javaTime) {
        return Archive.javaToDosTime(new Date(javaTime));
    }

    public static long javaToDosTime(Date date) {
        if (date == null || date.getTime() == 0L) {
            return 0L;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int year = cal.get(1);
        if (year < 1980) {
            return 0L;
        }
        int result = cal.get(5);
        result = cal.get(2) + 1 << 5 | result;
        result = cal.get(1) - 1980 << 9 | result;
        int time = cal.get(13) >> 1;
        time = cal.get(12) << 5 | time;
        time = cal.get(11) << 11 | time;
        return (long)result << 16 | (long)time;
    }
}

