/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.Archive;
import com.reandroid.archive.ArchiveUtil;
import com.reandroid.archive.block.CentralEntryHeader;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.io.FilePermissions;

public class ArchiveEntry {
    private final LocalFileHeader localFileHeader;

    public ArchiveEntry(LocalFileHeader lfh) {
        this.localFileHeader = lfh;
    }

    public long getDataSize() {
        if (this.getMethod() != Archive.DEFLATED) {
            return this.getSize();
        }
        return this.getCompressedSize();
    }

    public boolean isCompressed() {
        return this.getMethod() == Archive.DEFLATED;
    }

    public int getMethod() {
        return this.localFileHeader.getMethod();
    }

    public void setMethod(int method) {
        this.localFileHeader.setMethod(method);
        this.getCentralEntryHeader().setMethod(method);
    }

    public long getSize() {
        return this.localFileHeader.getSize();
    }

    public void setSize(long size) {
        this.localFileHeader.setSize(size);
        this.getCentralEntryHeader().setSize(size);
    }

    public long getCrc() {
        return this.localFileHeader.getCrc();
    }

    public void setCrc(long crc) {
        this.localFileHeader.setCrc(crc);
        this.getCentralEntryHeader().setCrc(crc);
    }

    public long getCompressedSize() {
        return this.localFileHeader.getCompressedSize();
    }

    public void setCompressedSize(long csize) {
        this.localFileHeader.setCompressedSize(csize);
        this.getCentralEntryHeader().setCompressedSize(csize);
    }

    public long getFileOffset() {
        return this.localFileHeader.getFileOffset();
    }

    public String getName() {
        return this.localFileHeader.getFileName();
    }

    public String getSanitizedName() {
        String name = ArchiveUtil.sanitizePath(this.localFileHeader.getFileName());
        if (name == null) {
            name = ".error_file_path_" + this.localFileHeader.getIndex();
        }
        return name;
    }

    public void setName(String name) {
        this.localFileHeader.setFileName(name);
        this.getCentralEntryHeader().setFileName(name);
    }

    public String getComment() {
        return this.getCentralEntryHeader().getComment();
    }

    public void setComment(String comment) {
        this.getCentralEntryHeader().setComment(comment);
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isDirectory() {
        return this.getDataSize() == 0L && this.getName().endsWith("/");
    }

    public FilePermissions getFilePermissions() {
        return this.getCentralEntryHeader().getFilePermissions();
    }

    public CentralEntryHeader getCentralEntryHeader() {
        CentralEntryHeader ceh = this.localFileHeader.getCentralEntryHeader();
        if (ceh == null) {
            ceh = CentralEntryHeader.fromLocalFileHeader(this.localFileHeader);
            this.localFileHeader.setCentralEntryHeader(ceh);
        }
        return ceh;
    }

    public LocalFileHeader getLocalFileHeader() {
        return this.localFileHeader;
    }

    public long getDosTime() {
        return this.getCentralEntryHeader().getDosTime();
    }

    public void setDosTime(long dosTime) {
        this.getCentralEntryHeader().setDosTime(dosTime);
        this.getLocalFileHeader().setDosTime(dosTime);
    }

    public int getIndex() {
        return this.getCentralEntryHeader().getIndex();
    }

    public String toString() {
        return "[" + this.getFileOffset() + "] " + this.getName() + this.getComment() + HexUtil.toHex(" 0x", this.getCrc(), 8);
    }
}

