/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive;

import com.reandroid.archive.ArchiveEntry;
import com.reandroid.archive.InputSource;
import com.reandroid.archive.block.CentralEntryHeader;
import com.reandroid.archive.block.DataDescriptor;
import com.reandroid.archive.block.LocalFileHeader;
import com.reandroid.archive.io.ArchiveFileEntrySource;
import com.reandroid.archive.writer.HeaderInterceptor;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.ObjectsUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class ArchiveInfo
implements HeaderInterceptor,
JSONConvert<JSONObject> {
    private long dosTime;
    private int cehVersionMadeBy;
    private int lfhVersionMadeBy;
    private int versionExtract;
    public static final String JSON_FILE = ObjectsUtil.of("archive-info.json");
    public static final String NAME_dosTime = ObjectsUtil.of("dos_time");
    public static final String NAME_cehVersionMadeBy = ObjectsUtil.of("ceh_version_made_by");
    public static final String NAME_lfhVersionMadeBy = ObjectsUtil.of("lfh_version_made_by");
    public static final String NAME_versionExtract = ObjectsUtil.of("version_extract");
    public static final String NAME_platform = ObjectsUtil.of("platform");

    public long getDosTime() {
        return this.dosTime;
    }

    public void setDosTime(long dosTime) {
        this.dosTime = dosTime;
    }

    public int getCehVersionMadeBy() {
        return this.cehVersionMadeBy;
    }

    public void setCehVersionMadeBy(int cehVersionMadeBy) {
        this.cehVersionMadeBy = cehVersionMadeBy;
    }

    public int getLfhVersionMadeBy() {
        return this.lfhVersionMadeBy;
    }

    public void setLfhVersionMadeBy(int lfhVersionMadeBy) {
        this.lfhVersionMadeBy = lfhVersionMadeBy;
    }

    public void setVersionExtract(int versionExtract) {
        this.versionExtract = versionExtract;
    }

    public int getVersionExtract() {
        return this.versionExtract;
    }

    @Override
    public void onWriteLfh(LocalFileHeader header) {
        int i;
        long dosTime = this.getDosTime();
        if (dosTime != -1L) {
            header.setDosTime(dosTime);
        }
        if ((i = this.getLfhVersionMadeBy()) != -1) {
            header.setVersionMadeBy(i);
        }
    }

    @Override
    public void onWriteDD(DataDescriptor dataDescriptor) {
    }

    @Override
    public void onWriteCeh(CentralEntryHeader header) {
        int i;
        long dosTime = this.getDosTime();
        if (dosTime != -1L) {
            header.setDosTime(dosTime);
        }
        if ((i = this.getCehVersionMadeBy()) != -1) {
            header.setVersionMadeBy(i);
        }
        if ((i = this.getVersionExtract()) != -1) {
            header.setVersionExtract(i);
        }
    }

    public void writeToDirectory(File dir) throws IOException {
        File file = new File(dir, JSON_FILE);
        this.write(file);
    }

    public void write(File file) throws IOException {
        this.toJson().write(file);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_dosTime, this.getDosTime());
        jsonObject.put(NAME_cehVersionMadeBy, this.getCehVersionMadeBy());
        jsonObject.put(NAME_lfhVersionMadeBy, this.getLfhVersionMadeBy());
        jsonObject.put(NAME_versionExtract, this.getVersionExtract());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.setDosTime(jsonObject.optLong(NAME_dosTime, this.getDosTime()));
        this.setCehVersionMadeBy(jsonObject.optInt(NAME_cehVersionMadeBy, this.getCehVersionMadeBy()));
        this.setLfhVersionMadeBy(jsonObject.optInt(NAME_lfhVersionMadeBy, this.getLfhVersionMadeBy()));
        this.setVersionExtract(jsonObject.optInt(NAME_versionExtract, this.getVersionExtract()));
    }

    public String toString() {
        return this.toJson().toString();
    }

    public static ArchiveInfo readJson(File fileOrDir) throws IOException {
        File file = fileOrDir.isFile() ? fileOrDir : new File(fileOrDir, JSON_FILE);
        if (!file.isFile()) {
            return null;
        }
        ArchiveInfo info = new ArchiveInfo();
        info.fromJson(new JSONObject(file));
        return info;
    }

    public static ArchiveInfo apk() {
        ArchiveInfo info = new ArchiveInfo();
        info.setDosTime(35719201L);
        info.setCehVersionMadeBy(768);
        info.setLfhVersionMadeBy(0);
        info.setVersionExtract(0);
        return info;
    }

    public static ArchiveInfo zip() {
        ArchiveInfo info = new ArchiveInfo();
        info.setDosTime(0x210000L);
        info.setCehVersionMadeBy(20);
        info.setLfhVersionMadeBy(20);
        info.setVersionExtract(20);
        return info;
    }

    public static ArchiveInfo build(InputSource[] sources) {
        return ArchiveInfo.build(ArchiveInfo.pick(sources));
    }

    public static ArchiveInfo build(Iterator<InputSource> iterator) {
        return ArchiveInfo.build(ArchiveInfo.pick(iterator));
    }

    public static ArchiveInfo build(ArchiveFileEntrySource entrySource) {
        if (entrySource == null) {
            return null;
        }
        ArchiveEntry entry = entrySource.getArchiveEntry();
        ArchiveInfo info = new ArchiveInfo();
        info.setDosTime(entry.getDosTime());
        info.setCehVersionMadeBy(entry.getCentralEntryHeader().getVersionMadeBy());
        info.setLfhVersionMadeBy(entry.getLocalFileHeader().getVersionMadeBy());
        info.setVersionExtract(entry.getCentralEntryHeader().getVersionExtract());
        return info;
    }

    private static ArchiveFileEntrySource pick(InputSource[] sources) {
        ArchiveFileEntrySource result = null;
        for (InputSource inputSource : sources) {
            if (!(inputSource instanceof ArchiveFileEntrySource)) continue;
            result = (ArchiveFileEntrySource)inputSource;
            String name = inputSource.getName();
            if (!name.startsWith("META-INF/")) break;
        }
        return result;
    }

    private static ArchiveFileEntrySource pick(Iterator<InputSource> iterator) {
        ArchiveFileEntrySource result = null;
        while (iterator.hasNext()) {
            InputSource inputSource = iterator.next();
            if (!(inputSource instanceof ArchiveFileEntrySource)) continue;
            result = (ArchiveFileEntrySource)inputSource;
            String name = inputSource.getName();
            if (name.startsWith("META-INF/")) continue;
            break;
        }
        return result;
    }
}

