/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.block;

import com.reandroid.archive.block.CertificateBlock;
import com.reandroid.archive.block.LengthPrefixedList;
import com.reandroid.archive.block.SignatureFooter;
import com.reandroid.archive.block.SignatureId;
import com.reandroid.archive.block.SignatureInfo;
import com.reandroid.archive.block.SignatureScheme;
import com.reandroid.archive.block.pad.SchemePadding;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ApkSignatureBlock
extends LengthPrefixedList<SignatureInfo>
implements Comparator<SignatureInfo> {
    public static final String FILE_EXT = ".sig";

    public ApkSignatureBlock(SignatureFooter signatureFooter) {
        super(true);
        this.setBottomBlock(signatureFooter);
    }

    public ApkSignatureBlock() {
        this(new SignatureFooter());
    }

    public Iterator<CertificateBlock> getCertificates() {
        return new IterableIterator<SignatureInfo, CertificateBlock>(this.iterator()){

            @Override
            public Iterator<CertificateBlock> iterator(SignatureInfo element) {
                return element.getCertificates();
            }
        };
    }

    public void sortSignatures() {
        this.sort(this);
    }

    public void updatePadding() {
        SchemePadding schemePadding = this.getOrCreateSchemePadding();
        schemePadding.setPadding(0);
        this.sortSignatures();
        this.refresh();
        int size = this.countBytes();
        int alignment = 4096;
        int padding = (alignment - size % alignment) % alignment;
        schemePadding.setPadding(padding);
        this.refresh();
    }

    private SchemePadding getOrCreateSchemePadding() {
        SignatureScheme scheme;
        SignatureInfo signatureInfo = this.getSignature(SignatureId.PADDING);
        if (signatureInfo == null) {
            signatureInfo = new SignatureInfo();
            signatureInfo.setId(SignatureId.PADDING);
            signatureInfo.setSignatureScheme(new SchemePadding());
            this.add(signatureInfo);
        }
        if (!((scheme = signatureInfo.getSignatureScheme()) instanceof SchemePadding)) {
            scheme = new SchemePadding();
            signatureInfo.setSignatureScheme(scheme);
        }
        return (SchemePadding)scheme;
    }

    public SignatureInfo getSignature(SignatureId signatureId) {
        for (SignatureInfo signatureInfo : this) {
            if (!signatureInfo.getId().equals(signatureId)) continue;
            return signatureInfo;
        }
        return null;
    }

    public SignatureFooter getSignatureFooter() {
        return (SignatureFooter)this.getBottomBlock();
    }

    @Override
    public SignatureInfo newInstance() {
        return new SignatureInfo();
    }

    @Override
    protected void onRefreshed() {
        SignatureFooter footer = this.getSignatureFooter();
        footer.updateMagic();
        super.onRefreshed();
        footer.setSignatureSize(this.getDataSize());
    }

    public void writeRaw(File file) throws IOException {
        this.refresh();
        OutputStream outputStream = FileUtil.outputStream(file);
        this.writeBytes(outputStream);
        outputStream.close();
    }

    public List<File> writeSplitRawToDirectory(File dir) throws IOException {
        this.refresh();
        ArrayCollection<File> writtenFiles = new ArrayCollection<File>(this.size());
        for (SignatureInfo signatureInfo : this) {
            File file = signatureInfo.writeRawToDirectory(dir);
            writtenFiles.add(file);
        }
        return writtenFiles;
    }

    public void read(File file) throws IOException {
        super.readBytes(new BlockReader(file));
    }

    public void scanSplitFiles(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException("No such directory");
        }
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                String name = file.getName().toLowerCase();
                return name.endsWith(".signature.info.bin");
            }
        };
        File[] files = dir.listFiles(filter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            this.addSplitRaw(file);
        }
        this.sortSignatures();
    }

    public SignatureInfo addSplitRaw(File signatureInfoFile) throws IOException {
        SignatureInfo signatureInfo = new SignatureInfo();
        signatureInfo.read(signatureInfoFile);
        this.add(signatureInfo);
        return signatureInfo;
    }

    @Override
    public int compare(SignatureInfo info1, SignatureInfo info2) {
        return info1.getId().compareTo(info2.getId());
    }
}

