/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.archive.io;

import com.reandroid.archive.io.ZipInput;
import com.reandroid.common.FileChannelInputStream;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class ZipFileInput
extends ZipInput {
    private final File file;
    private FileChannel fileChannel;
    private InputStream mCurrentInputStream;

    public ZipFileInput(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public long position() throws IOException {
        FileChannel fileChannel = this.fileChannel;
        if (fileChannel != null) {
            return fileChannel.position();
        }
        return 0L;
    }

    @Override
    public void position(long pos) throws IOException {
        this.getFileChannel().position(pos);
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public InputStream getInputStream(long offset, long length) throws IOException {
        this.closeCurrentInputStream();
        FileChannel fileChannel = this.getFileChannel();
        fileChannel.position(offset);
        this.mCurrentInputStream = new FileChannelInputStream(fileChannel, length);
        return this.mCurrentInputStream;
    }

    @Override
    public byte[] getFooter(int minLength) throws IOException {
        long position = this.getLength();
        if ((long)minLength > position) {
            minLength = (int)position;
        }
        FileChannel fileChannel = this.getFileChannel();
        fileChannel.position(position -= (long)minLength);
        ByteBuffer buffer = ByteBuffer.allocate(minLength);
        fileChannel.read(buffer);
        return buffer.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getFileChannel() throws IOException {
        FileChannel fileChannel = this.fileChannel;
        if (fileChannel != null) {
            return fileChannel;
        }
        ZipFileInput zipFileInput = this;
        synchronized (zipFileInput) {
            this.fileChannel = fileChannel = FileUtil.openReadChannel(this.file);
            return fileChannel;
        }
    }

    @Override
    public void close() throws IOException {
        this.closeCurrentInputStream();
        this.closeChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        FileChannel fileChannel = this.fileChannel;
        if (fileChannel == null) {
            return false;
        }
        ZipFileInput zipFileInput = this;
        synchronized (zipFileInput) {
            return fileChannel.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChannel() throws IOException {
        FileChannel fileChannel = this.fileChannel;
        if (fileChannel == null) {
            return;
        }
        ZipFileInput zipFileInput = this;
        synchronized (zipFileInput) {
            fileChannel.close();
            this.fileChannel = null;
        }
    }

    private void closeCurrentInputStream() throws IOException {
        InputStream current = this.mCurrentInputStream;
        if (current == null) {
            return;
        }
        current.close();
        this.mCurrentInputStream = null;
    }

    public String toString() {
        return "File: " + this.file;
    }
}

