/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk;

import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.OverlayablePolicy;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.header.OverlayableHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class Overlayable
extends Chunk<OverlayableHeader>
implements Iterable<OverlayablePolicy>,
JSONConvert<JSONObject> {
    private final BlockList<OverlayablePolicy> policyList = new BlockList();
    public static final String NAME_name = ObjectsUtil.of("name");
    public static final String NAME_actor = ObjectsUtil.of("actor");
    public static final String NAME_policies = ObjectsUtil.of("policies");
    public static final String TAG_overlayable = ObjectsUtil.of("overlayable");
    public static final String FILE_NAME_XML = ObjectsUtil.of("overlayable.xml");

    public Overlayable() {
        super(new OverlayableHeader(), 2);
        this.addChild(this.policyList);
    }

    @Override
    public Iterator<OverlayablePolicy> iterator() {
        return this.policyList.iterator();
    }

    public OverlayablePolicy createNext() {
        OverlayablePolicy overlayablePolicy = new OverlayablePolicy();
        this.policyList.add(overlayablePolicy);
        return overlayablePolicy;
    }

    public OverlayablePolicy getByFlag(int flags) {
        for (OverlayablePolicy policy : this) {
            if (flags != policy.getFlags()) continue;
            return policy;
        }
        return null;
    }

    public void addPolicy(OverlayablePolicy overlayablePolicy) {
        this.policyList.add(overlayablePolicy);
    }

    public String getName() {
        return ((OverlayableHeader)this.getHeaderBlock()).getName().get();
    }

    public void setName(String str) {
        ((OverlayableHeader)this.getHeaderBlock()).getName().set(str);
    }

    public String getActor() {
        return ((OverlayableHeader)this.getHeaderBlock()).getActor().get();
    }

    public void setActor(String str) {
        ((OverlayableHeader)this.getHeaderBlock()).getActor().set(str);
    }

    @Override
    protected void onChunkRefreshed() {
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        InfoHeader headerBlock = reader.readHeaderBlock();
        this.checkInvalidChunk(headerBlock);
        int size = headerBlock.getChunkSize();
        BlockReader chunkReader = reader.create(size);
        headerBlock = this.getHeaderBlock();
        headerBlock.readBytes(chunkReader);
        this.readOverlayablePolicies(chunkReader);
        reader.offset(size);
        chunkReader.close();
        this.onChunkLoaded();
    }

    private void readOverlayablePolicies(BlockReader reader) throws IOException {
        InfoHeader headerBlock = reader.readHeaderBlock();
        BlockList<OverlayablePolicy> policyList = this.policyList;
        while (headerBlock != null && headerBlock.getChunkType() == ChunkType.OVERLAYABLE_POLICY) {
            OverlayablePolicy policy = new OverlayablePolicy();
            policyList.add(policy);
            policy.readBytes(reader);
            headerBlock = reader.readHeaderBlock();
        }
    }

    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        XMLUtil.ensureStartTag(parser);
        if (!TAG_overlayable.equals(parser.getName())) {
            throw new XmlPullParserException("Expecting tag '" + TAG_overlayable + "', but found '" + parser.getName() + "'");
        }
        this.setName(parser.getAttributeValue(null, NAME_name));
        this.setActor(parser.getAttributeValue(null, NAME_actor));
        parser.next();
        XMLUtil.ensureTag(parser);
        while (parser.getEventType() != 3 && parser.getEventType() != 1) {
            OverlayablePolicy overlayablePolicy = this.createNext();
            overlayablePolicy.parse(parser);
            XMLUtil.ensureTag(parser);
        }
        if (parser.getEventType() == 3) {
            parser.next();
            XMLUtil.ensureTag(parser);
        }
    }

    public void serialize(XmlSerializer serializer) throws IOException {
        String actor;
        serializer.startTag(null, TAG_overlayable);
        String name = this.getName();
        if (!StringsUtil.isEmpty(name)) {
            serializer.attribute(null, NAME_name, name);
        }
        if (!StringsUtil.isEmpty(actor = this.getActor())) {
            serializer.attribute(null, NAME_actor, actor);
        }
        for (OverlayablePolicy overlayablePolicy : this) {
            overlayablePolicy.serialize(serializer);
        }
        serializer.endTag(null, TAG_overlayable);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_name, this.getName());
        jsonObject.put(NAME_actor, this.getActor());
        JSONArray jsonArray = new JSONArray();
        for (OverlayablePolicy policy : this) {
            jsonArray.put(policy.toJson());
        }
        jsonObject.put(NAME_policies, jsonArray);
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setName(json.optString(NAME_name, null));
        this.setActor(json.optString(NAME_actor, null));
        JSONArray jsonArray = json.getJSONArray(NAME_policies);
        int length = jsonArray.length();
        for (int i = 0; i < length; ++i) {
            this.createNext().fromJson(jsonArray.getJSONObject(i));
        }
    }

    public void merge(Overlayable overlayable) {
        if (overlayable == null || overlayable == this) {
            return;
        }
        this.setName(overlayable.getName());
        this.setActor(overlayable.getActor());
        for (OverlayablePolicy policy : overlayable) {
            OverlayablePolicy exist = this.getByFlag(policy.getFlags());
            if (exist == null) {
                exist = this.createNext();
            }
            exist.merge(policy);
        }
    }

    @Override
    public String toString() {
        return "name='" + this.getName() + "', actor='" + this.getActor() + "', policies=" + this.policyList.size();
    }
}

