/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.archive.InputSource;
import com.reandroid.arsc.ApkFile;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.MainChunk;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.ParentChunk;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.xml.ResXmlDocumentChunk;
import com.reandroid.arsc.chunk.xml.ResXmlDocumentOrElement;
import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlEvent;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlNodeList;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.InfoHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import com.reandroid.utils.io.FileUtil;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLFactory;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.base.Document;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ResXmlDocument
extends ResXmlDocumentOrElement
implements Document<ResXmlElement>,
MainChunk,
ParentChunk {
    private ApkFile apkFile;

    public ResXmlDocument() {
        super(new ResXmlDocumentChunk());
    }

    @Override
    public ResXmlElement getDocumentElement() {
        ResXmlElement element = (ResXmlElement)CollectionUtil.getFirst(this.getElements());
        if (element == null) {
            ResXmlDocument childDocument = CollectionUtil.getFirst(this.iterator(ResXmlDocument.class));
            if (childDocument != null) {
                element = (ResXmlElement)CollectionUtil.getFirst(childDocument.getElements());
            }
            if (element == null) {
                element = this.newElement();
            }
        }
        return element;
    }

    @Override
    public ApkFile getApkFile() {
        ResXmlDocument parentDocument;
        ApkFile apkFile = this.apkFile;
        if (apkFile == null && (parentDocument = this.getParentDocument()) != null) {
            apkFile = parentDocument.getApkFile();
        }
        return apkFile;
    }

    @Override
    public void setApkFile(ApkFile apkFile) {
        this.apkFile = apkFile;
    }

    @Override
    public TableBlock getTableBlock() {
        return this.getChunk().getTableBlock();
    }

    @Override
    public StringPool<?> getSpecStringPool() {
        return null;
    }

    @Override
    public MainChunk getMainChunk() {
        return this;
    }

    @Override
    public PackageBlock getPackageBlock() {
        ResXmlDocument parentDocument;
        PackageBlock packageBlock = this.getChunk().getPackageBlock();
        if (packageBlock == null && (parentDocument = this.getParentDocument()) != null) {
            packageBlock = parentDocument.getPackageBlock();
        }
        return packageBlock;
    }

    public void setPackageBlock(PackageBlock packageBlock) {
        this.getChunk().setPackageBlock(packageBlock);
    }

    private ResXmlDocument getParentDocument() {
        return this.getParentInstance(ResXmlDocument.class);
    }

    @Override
    ResXmlDocumentChunk getChunk() {
        return (ResXmlDocumentChunk)super.getChunk();
    }

    @Override
    public XMLDocument toXml(boolean decode) {
        XMLDocument xmlDocument = new XMLDocument();
        xmlDocument.setEncoding(this.getEncoding());
        Iterator<ResXmlNode> iterator = this.iterator();
        while (iterator.hasNext()) {
            ResXmlNode node = iterator.next();
            xmlDocument.add(node.toXml(decode));
        }
        return xmlDocument;
    }

    public void readBytes(File file) throws IOException {
        BlockReader reader = new BlockReader(file);
        super.readBytes(reader);
    }

    public void readBytes(InputStream inputStream) throws IOException {
        BlockReader reader = new BlockReader(inputStream);
        super.readBytes(reader);
    }

    public final int writeBytes(File file) throws IOException {
        if (this.isNull()) {
            throw new IOException("Can NOT save null block");
        }
        OutputStream outputStream = FileUtil.outputStream(file);
        int length = super.writeBytes(outputStream);
        outputStream.close();
        return length;
    }

    public String serializeToXml() throws IOException {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XMLFactory.newSerializer(writer);
        this.serialize(serializer);
        serializer.flush();
        writer.flush();
        writer.close();
        return writer.toString();
    }

    @Override
    public boolean isDocument() {
        return true;
    }

    @Override
    String nodeTypeName() {
        return JSON_node_type_document;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(JSON_encoding, this.getStringPool().getEncoding());
        jsonObject.put(JSON_node_type, this.nodeTypeName());
        jsonObject.put(JSON_nodes, this.nodesToJson());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.getStringPool().setEncoding(json.optString(JSON_encoding));
        this.nodesFromJson(json);
        this.refresh();
    }

    public String getEncoding() {
        if (XMLUtil.KEEP_CHARSET_ENCODING) {
            return this.getStringPool().getEncoding();
        }
        return "utf-8";
    }

    public void setEncoding(String encoding) {
        if (XMLUtil.KEEP_CHARSET_ENCODING) {
            this.getStringPool().setEncoding(encoding);
        }
    }

    @Override
    public int getLineNumber() {
        return 1;
    }

    @Override
    public void setLineNumber(int lineNumber) {
    }

    @Override
    public int getStartLineNumber() {
        int line = 1;
        ResXmlNode previous = this.getPrevious();
        if (previous != null) {
            line += previous.getEndLineNumber();
        }
        return line;
    }

    @Override
    public int getEndLineNumber() {
        int line = this.getStartLineNumber();
        ResXmlNode last = this.get(this.size() - 1);
        if (last != null) {
            line += last.getEndLineNumber();
        }
        return ++line;
    }

    @Override
    ResXmlNodeList getNodeList() {
        return this.getChunk().getNodeList();
    }

    @Override
    Iterator<ResXmlEvent> getParserEvents() {
        return CombiningIterator.singleTwo(ResXmlEvent.startDocument(this), new IterableIterator<ResXmlNode, ResXmlEvent>(this.iterator()){

            @Override
            public Iterator<ResXmlEvent> iterator(ResXmlNode node) {
                return node.getParserEvents();
            }
        }, SingleIterator.of(ResXmlEvent.endDocument(this)));
    }

    @Override
    int autoSetLineNumber(int start) {
        int result = 0;
        Iterator<ResXmlNode> iterator = this.iterator();
        while (iterator.hasNext()) {
            start = iterator.next().autoSetLineNumber(start);
        }
        return result;
    }

    public ResXmlStringPool getStringPool() {
        return this.getChunk().getStringPool();
    }

    public ResXmlIDMap getResXmlIDMap() {
        return this.getChunk().getResXmlIDMap();
    }

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        this.serialize(serializer, true);
    }

    @Override
    public void serialize(XmlSerializer serializer, boolean decode) throws IOException {
        PackageBlock packageBlock = this.getPackageBlock();
        if (decode && packageBlock == null) {
            throw new IOException("Can not decode without package");
        }
        ResXmlDocument.setIndent(serializer, true);
        String encoding = this.getEncoding();
        serializer.startDocument(encoding, encoding == null ? Boolean.FALSE : null);
        this.fixNamespaces();
        this.removeUnusedNamespaces();
        this.serializeNodes(serializer, decode);
        serializer.endDocument();
    }

    @Override
    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            throw new IOException("Can not decode without package");
        }
        this.setPackageBlock(packageBlock);
        this.removeNullElements();
        int event = parser.getEventType();
        if (event == 0) {
            parser.nextToken();
            this.setEncoding(parser.getInputEncoding());
        }
        this.parseInnerNodes(parser);
        this.refreshFull();
    }

    PackageBlock selectPackageBlock(TableBlock tableBlock) {
        return this.getChunk().selectPackageBlock(tableBlock);
    }

    public void refreshFull() {
        this.removeNullElements();
        this.fixNamespaces();
        this.removeUnusedNamespaces();
        this.removeUndefinedAttributes();
        this.getChunk().refreshFull();
        this.refresh();
    }

    public static boolean isResXmlBlock(InputSource inputSource) {
        boolean result = false;
        try {
            InputStream inputStream = inputSource.openStream();
            result = ResXmlDocument.isResXmlBlock(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isResXmlBlock(File file) {
        boolean result = false;
        try {
            InputStream inputStream = FileUtil.inputStream(file);
            result = ResXmlDocument.isResXmlBlock(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isResXmlBlock(InputStream inputStream) {
        try {
            InfoHeader headerBlock = BlockReader.readHeaderBlock(inputStream);
            return ResXmlDocument.isResXmlBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResXmlBlock(byte[] bytes) {
        try {
            InfoHeader headerBlock = BlockReader.readHeaderBlock(bytes);
            return ResXmlDocument.isResXmlBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResXmlBlock(BlockReader blockReader) {
        if (blockReader == null) {
            return false;
        }
        try {
            InfoHeader headerBlock = blockReader.readHeaderBlock();
            return ResXmlDocument.isResXmlBlock(headerBlock);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static boolean isResXmlBlock(HeaderBlock headerBlock) {
        if (headerBlock == null) {
            return false;
        }
        ChunkType chunkType = headerBlock.getChunkType();
        return chunkType == ChunkType.XML;
    }
}

