/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.xml.ResXmlAttribute;
import com.reandroid.arsc.chunk.xml.ResXmlAttributeArray;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlDocumentOrElement;
import com.reandroid.arsc.chunk.xml.ResXmlElementChunk;
import com.reandroid.arsc.chunk.xml.ResXmlEndElement;
import com.reandroid.arsc.chunk.xml.ResXmlEvent;
import com.reandroid.arsc.chunk.xml.ResXmlNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlNodeList;
import com.reandroid.arsc.chunk.xml.ResXmlNodeTree;
import com.reandroid.arsc.chunk.xml.ResXmlStartElement;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespace;
import com.reandroid.arsc.chunk.xml.ResXmlStartNamespaceList;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.common.Namespace;
import com.reandroid.json.JSONException;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.base.Element;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ResXmlElement
extends ResXmlDocumentOrElement
implements Element<ResXmlNode> {
    public ResXmlElement() {
        super(new ResXmlElementChunk());
    }

    @Override
    public String getName() {
        return this.getStartElement().getName();
    }

    @Override
    public String getName(boolean includePrefix) {
        return this.getStartElement().getName(includePrefix);
    }

    @Override
    public void setName(String name) {
        this.getChunk().setName(name);
    }

    public boolean equalsName(String name) {
        if (name == null) {
            return this.getName() == null;
        }
        name = XMLUtil.splitName(name);
        return name.equals(this.getName(false));
    }

    @Override
    public ResXmlNamespace getNamespace() {
        return this.getChunk().getStartElement().getResXmlStartNamespace();
    }

    @Override
    public void setNamespace(Namespace namespace) {
        if (namespace != null) {
            this.setNamespace(namespace.getUri(), namespace.getPrefix());
        } else {
            this.setNamespace(null, null);
        }
    }

    public void setNamespace(String uri, String prefix) {
        this.getStartElement().setTagNamespace(uri, prefix);
    }

    @Override
    public String getPrefix() {
        return this.getStartElement().getPrefix();
    }

    @Override
    public String getUri() {
        return this.getStartElement().getUri();
    }

    @Override
    ResXmlElementChunk getChunk() {
        return (ResXmlElementChunk)super.getChunk();
    }

    @Override
    ResXmlNodeList getNodeList() {
        return this.getChunk().getNodeList();
    }

    @Override
    public int getAttributeCount() {
        return this.getAttributeArray().size();
    }

    @Override
    public ResXmlAttribute getAttributeAt(int i) {
        return (ResXmlAttribute)this.getAttributeArray().get(i);
    }

    @Override
    public Iterator<ResXmlAttribute> getAttributes() {
        return this.getAttributeArray().clonedIterator();
    }

    public Iterator<ResXmlAttribute> getAttributes(Predicate<? super ResXmlAttribute> predicate) {
        return this.getAttributeArray().iterator(predicate);
    }

    public boolean removeAttribute(ResXmlAttribute attribute) {
        return this.getAttributeArray().remove(attribute);
    }

    public boolean removeAttributeAt(int index) {
        return this.getAttributeArray().remove(index) != null;
    }

    public boolean removeAttributeIf(Predicate<? super ResXmlAttribute> predicate) {
        return this.getAttributeArray().removeIf(predicate);
    }

    public boolean removeAttributesWithId(int resourceId) {
        return this.removeAttributeIf(attribute -> attribute.equalsNameId(resourceId));
    }

    public boolean removeAttributesWithName(String name) {
        return this.removeAttributeIf(attribute -> attribute.equalsNameWithNoId(name));
    }

    @Override
    public int getNamespaceCount() {
        return this.getNamespaceList().size();
    }

    @Override
    public ResXmlNamespace getNamespaceAt(int i) {
        return (ResXmlNamespace)this.getNamespaceList().get(i);
    }

    @Override
    public Iterator<ResXmlNamespace> getNamespaces() {
        return this.getNamespaceList().getNamespaces();
    }

    public boolean removeNamespace(ResXmlNamespace namespace) {
        return this.getNamespaceList().remove((ResXmlStartNamespace)namespace);
    }

    public boolean removeNamespaceIf(Predicate<? super ResXmlNamespace> predicate) {
        return this.getNamespaceList().removeIf(predicate);
    }

    public Iterator<ResXmlNamespace> getVisibleNamespaces() {
        return (Iterator)ObjectsUtil.cast(this.getNamespaceList().getVisibleNamespaces());
    }

    ResXmlNamespace getNamespaceForUriReference(int reference) {
        return this.getNamespaceList().getForUriReference(reference);
    }

    public ResXmlNamespace getNamespace(String uri, String prefix) {
        return this.getNamespaceList().get(uri, prefix);
    }

    public ResXmlNamespace getOrCreateNamespace(String uri, String prefix) {
        return this.getNamespaceList().getOrCreate(uri, prefix);
    }

    public ResXmlNamespace getNamespaceForUri(String uri) {
        return this.getNamespaceList().getForUri(uri);
    }

    public ResXmlNamespace getNamespaceForPrefix(String prefix) {
        return this.getNamespaceList().getForPrefix(prefix);
    }

    public ResXmlNamespace getOrCreateNamespaceForPrefix(String prefix) {
        return this.getNamespaceList().getOrCreateForPrefix(prefix);
    }

    public String getComment() {
        String end;
        String comment = this.getStartComment();
        if (StringsUtil.isEmpty(comment) && (end = this.getEndComment()) != null) {
            comment = end;
        }
        return comment;
    }

    public void setComment(String comment) {
        this.setStartComment(comment);
    }

    public String getStartComment() {
        return this.getStartElement().getComment();
    }

    public void setStartComment(String comment) {
        this.getStartElement().setComment(comment);
    }

    public String getEndComment() {
        return this.getEndElement().getComment();
    }

    public void setEndComment(String comment) {
        this.getEndElement().setComment(comment);
    }

    @Override
    public void setAttributesUnitSize(int size, boolean recursive) {
        this.getStartElement().getAttributeUnitSize().set(size);
        if (recursive) {
            super.setAttributesUnitSize(size, true);
        }
    }

    @Override
    public ResXmlNamespace newNamespace(String uri, String prefix) {
        return this.getNamespaceList().createNext(uri, prefix);
    }

    @Override
    public ResXmlAttribute newAttribute() {
        return this.getAttributeArray().createNext();
    }

    public ResXmlAttribute newAttribute(String name, int resourceId) {
        ResXmlAttribute attribute = this.newAttribute();
        attribute.setName(name, resourceId);
        return attribute;
    }

    @Override
    void linkStringReferences() {
        this.getChunk().linkStringReferences();
        super.linkStringReferences();
    }

    @Override
    Iterator<ResXmlEvent> getParserEvents() {
        return CombiningIterator.singleThree(ResXmlEvent.startTag(this), SingleIterator.of(ResXmlEvent.startComment(this)), new IterableIterator<ResXmlNode, ResXmlEvent>(this.iterator()){

            @Override
            public Iterator<ResXmlEvent> iterator(ResXmlNode node) {
                return node.getParserEvents();
            }
        }, CombiningIterator.singleOne(ResXmlEvent.endComment(this), SingleIterator.of(ResXmlEvent.endTag(this))));
    }

    @Override
    int autoSetLineNumber(int start) {
        ++start;
        Iterator<ResXmlNamespace> namespaces = this.getNamespaces();
        while (namespaces.hasNext()) {
            namespaces.next().setLineNumber(start);
        }
        this.getStartElement().setLineNumber(start);
        Iterator<ResXmlNode> iterator = this.iterator();
        int i = start;
        while (iterator.hasNext()) {
            ResXmlNode node = iterator.next();
            start = node.autoSetLineNumber(start);
        }
        if (i != start) {
            ++start;
        }
        this.getEndElement().setLineNumber(start);
        return start;
    }

    @Override
    public XMLElement toXml(boolean decode) {
        XMLElement element = new XMLElement();
        element.setName(this.getName(false));
        Iterator<ResXmlNamespace> namespaces = this.getNamespaces();
        while (namespaces.hasNext()) {
            ResXmlNamespace namespace = namespaces.next();
            element.addNamespace(namespace.getUri(), namespace.getPrefix());
        }
        element.setNamespace(this.getNamespace());
        this.getAttributeArray().toXml(element, decode);
        return element;
    }

    @Override
    public boolean isElement() {
        return true;
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.setStartLineNumber(lineNumber);
    }

    @Override
    public int getStartLineNumber() {
        return this.getStartElement().getLineNumber();
    }

    public void setStartLineNumber(int lineNumber) {
        this.getStartElement().setLineNumber(lineNumber);
    }

    @Override
    public int getEndLineNumber() {
        return this.getEndElement().getLineNumber();
    }

    public void setEndLineNumber(int lineNumber) {
        this.getEndElement().setLineNumber(lineNumber);
    }

    public ResXmlElement getParentElement() {
        ResXmlNodeTree parent = this.getParentNode();
        if (parent instanceof ResXmlElement) {
            return (ResXmlElement)parent;
        }
        return null;
    }

    public ResXmlElement getRootElement() {
        return CollectionUtil.getLast(this.getParentElementsWithSelf());
    }

    public Iterator<ResXmlElement> getParentElementsWithSelf() {
        return this.visitParentNodes(ResXmlElement.class, ResXmlDocument.class);
    }

    public Iterator<ResXmlElement> getDescendingParentsWithSelf() {
        return CollectionUtil.reversedOf(this.getParentElementsWithSelf());
    }

    public ResXmlDocument getParentDocument() {
        return this.getParentInstance(ResXmlDocument.class);
    }

    public ResXmlStringPool getStringPool() {
        ResXmlDocument document = this.getParentDocument();
        if (document != null) {
            return document.getStringPool();
        }
        return null;
    }

    public boolean isUndefined() {
        return this.size() == 0 && this.getAttributeCount() == 0 && this.getNamespaceCount() == 0 && StringsUtil.isEmpty(this.getName());
    }

    public ResXmlAttribute getOrCreateAndroidAttribute(String name, int resourceId) {
        return this.getAttributeArray().getOrCreateAndroidAttribute(name, resourceId);
    }

    public ResXmlAttribute getOrCreateAttribute(String uri, String prefix, String name, int resourceId) {
        return this.getAttributeArray().getOrCreateAttribute(uri, prefix, name, resourceId);
    }

    public ResXmlAttribute getOrCreateAttribute(String name, int resourceId) {
        return this.getAttributeArray().getOrCreateAttribute(name, resourceId);
    }

    public ResXmlAttribute createAndroidAttribute(String name, int resourceId) {
        return this.getAttributeArray().getOrCreateAndroidAttribute(name, resourceId);
    }

    public ResXmlAttribute createAttribute(String name, int resourceId) {
        return this.newAttribute(name, resourceId);
    }

    public ResXmlAttribute searchAttributeByName(String name) {
        return this.getAttributeArray().searchAttributeByName(name);
    }

    public ResXmlAttribute searchAttributeByResourceId(int resourceId) {
        return this.getAttributeArray().searchAttributeByResourceId(resourceId);
    }

    public ResXmlAttribute searchAttribute(String namespace, String name) {
        return this.getAttributeArray().searchAttribute(namespace, name);
    }

    public ResXmlAttribute getIdAttribute() {
        return this.getStartElement().getIdAttributePosition().getAttribute();
    }

    public ResXmlAttribute getClassAttribute() {
        return this.getStartElement().getClassAttributePosition().getAttribute();
    }

    public ResXmlAttribute getStyleAttribute() {
        return this.getStartElement().getStyleAttributePosition().getAttribute();
    }

    private ResXmlAttributeArray getAttributeArray() {
        return this.getStartElement().getResXmlAttributeArray();
    }

    private ResXmlStartElement getStartElement() {
        return this.getChunk().getStartElement();
    }

    ResXmlStartNamespaceList getNamespaceList() {
        return this.getChunk().getStartNamespaceList();
    }

    private ResXmlEndElement getEndElement() {
        return this.getChunk().getEndElement();
    }

    @Override
    public void merge(ResXmlNode xmlNode) {
        if (xmlNode == this) {
            return;
        }
        ResXmlElement coming = (ResXmlElement)xmlNode;
        this.setName(coming.getName(false));
        this.getNamespaceList().merge(coming.getNamespaceList());
        this.setNamespace(coming.getNamespace());
        this.getAttributeArray().merge(coming.getAttributeArray());
        this.setStartComment(coming.getStartComment());
        this.setEndComment(coming.getEndComment());
        this.setStartLineNumber(coming.getStartLineNumber());
        super.merge(xmlNode);
        this.setEndLineNumber(coming.getEndLineNumber());
    }

    @Override
    public void mergeWithName(ResourceMergeOption mergeOption, ResXmlNode xmlNode) {
        if (xmlNode == this) {
            return;
        }
        ResXmlElement coming = (ResXmlElement)xmlNode;
        this.setName(coming.getName(false));
        this.getNamespaceList().merge(coming.getNamespaceList());
        this.setNamespace(coming.getNamespace());
        this.getAttributeArray().mergeWithName(mergeOption, coming.getAttributeArray());
        this.setStartComment(coming.getStartComment());
        this.setEndComment(coming.getEndComment());
        this.setStartLineNumber(coming.getStartLineNumber());
        super.mergeWithName(mergeOption, xmlNode);
        this.setEndLineNumber(coming.getEndLineNumber());
    }

    private void setNamespaceFromJson(JSONObject jsonObject) {
        String uri = jsonObject.optString(JSON_uri, null);
        String prefix = jsonObject.optString(JSON_prefix, null);
        if (uri == null && prefix != null) {
            throw new JSONException("Provided " + JSON_prefix + "=" + prefix + ", but missing: " + JSON_uri);
        }
        if (prefix == null && uri != null) {
            throw new JSONException("Provided " + JSON_uri + "=" + uri + ", but missing: " + JSON_prefix);
        }
        this.setNamespace(uri, prefix);
    }

    @Override
    String nodeTypeName() {
        return JSON_node_type_element;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(JSON_node_type, this.nodeTypeName());
        jsonObject.put(JSON_namespaces, this.getNamespaceList().toJson());
        jsonObject.put(JSON_name, this.getName());
        jsonObject.put(JSON_uri, this.getUri());
        jsonObject.put(JSON_prefix, this.getPrefix());
        jsonObject.put(JSON_line, this.getStartLineNumber());
        jsonObject.put(JSON_line_end, this.getEndLineNumber());
        jsonObject.put(JSON_comment, this.getComment());
        jsonObject.put(JSON_attributes, this.getAttributeArray().toJson());
        jsonObject.put(JSON_nodes, this.nodesToJson());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setName(json.getString(JSON_name));
        this.setStartLineNumber(json.optInt(JSON_line));
        this.setEndLineNumber(json.optInt(JSON_line));
        this.getNamespaceList().fromJson(json.optJSONArray(JSON_namespaces));
        this.setNamespaceFromJson(json);
        this.setComment(json.optString(JSON_comment, null));
        this.getAttributeArray().fromJson(json.optJSONArray(JSON_attributes));
        this.nodesFromJson(json);
    }

    @Override
    public void serialize(XmlSerializer serializer, boolean decode) throws IOException {
        ResXmlElement.setIndent(serializer, true);
        Iterator<ResXmlNamespace> namespaces = this.getNamespaces();
        while (namespaces.hasNext()) {
            ResXmlNamespace namespace = namespaces.next();
            serializer.setPrefix(namespace.getPrefix(), namespace.getUri());
        }
        this.serializeComment(serializer, this.getStartComment());
        serializer.startTag(this.getUri(), this.getName(false));
        this.getAttributeArray().serialize(serializer, decode);
        this.serializeNodes(serializer, decode);
        serializer.endTag(this.getUri(), this.getName(false));
        this.serializeComment(serializer, this.getEndComment());
    }

    @Override
    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        XMLUtil.expectEvent(parser, 2);
        this.setStartLineNumber(parser.getLineNumber());
        this.getNamespaceList().parse(parser);
        this.setName(parser.getName());
        this.setNamespace(parser.getNamespace(), parser.getPrefix());
        this.getAttributeArray().parse(parser);
        parser.nextToken();
        this.parseInnerNodes(parser);
        parser.nextToken();
    }

    @Override
    public void removeUnusedNamespaces() {
        this.removeNamespaceIf(ResXmlNamespace::isUnused);
        super.removeUnusedNamespaces();
    }

    @Override
    public void removeUndefinedAttributes() {
        this.removeAttributeIf(ResXmlAttribute::isUndefined);
        super.removeUndefinedAttributes();
    }

    @Override
    public void fixNamespaces() {
        Iterator<ResXmlNamespace> namespaces = this.getNamespaces();
        while (namespaces.hasNext()) {
            ResXmlStartNamespace namespace = (ResXmlStartNamespace)namespaces.next();
            namespace.fixEmpty();
        }
        Iterator<ResXmlAttribute> iterator = this.getAttributes();
        while (iterator.hasNext()) {
            iterator.next().autoSetNamespace();
        }
        super.fixNamespaces();
    }

    @Override
    void onPreRemove() {
        super.onPreRemove();
        this.getChunk().onPreRemove();
    }

    @Override
    public String toString() {
        Iterator<ResXmlAttribute> attributes;
        this.touchChildNodesForDebug();
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append(this.getName(true));
        Iterator<ResXmlNamespace> namespaces = this.getNamespaces();
        if (namespaces.hasNext()) {
            builder.append(' ');
            builder.append(StringsUtil.join(namespaces, (Object)Character.valueOf(' ')));
        }
        if ((attributes = this.getAttributes()).hasNext()) {
            builder.append(' ');
            builder.append(StringsUtil.join(attributes, (Object)Character.valueOf(' ')));
        }
        builder.append('>');
        return builder.toString();
    }
}

