/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import android.content.res.XmlResourceParser;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.xml.ResXmlEvent;
import com.reandroid.arsc.chunk.xml.ResXmlEventParser;
import com.reandroid.arsc.chunk.xml.ResXmlNodeTree;
import com.reandroid.arsc.chunk.xml.ResXmlPullParser;
import com.reandroid.arsc.container.WrappedBlock;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.base.Node;
import java.io.IOException;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public abstract class ResXmlNode
extends WrappedBlock
implements Node,
JSONConvert<JSONObject> {
    private static final String FEATURE_INDENT_OUTPUT = "http://xmlpull.org/v1/doc/features.html#indent-output";
    public static final String JSON_encoding = ObjectsUtil.of("encoding");
    public static final String JSON_node_type = ObjectsUtil.of("node_type");
    public static final String JSON_node_type_document = ObjectsUtil.of("document");
    public static final String JSON_node_type_element = ObjectsUtil.of("element");
    public static final String JSON_node_type_text = ObjectsUtil.of("text");
    public static final String JSON_node_type_comment = ObjectsUtil.of("comment");
    public static final String JSON_node_type_unknown = ObjectsUtil.of("unknown");
    public static final String JSON_name = ObjectsUtil.of("name");
    public static final String JSON_id = ObjectsUtil.of("id");
    public static final String JSON_comment = ObjectsUtil.of("comment");
    public static final String JSON_namespaces = ObjectsUtil.of("namespaces");
    public static final String JSON_uri = ObjectsUtil.of("uri");
    public static final String JSON_prefix = ObjectsUtil.of("prefix");
    public static final String JSON_line = ObjectsUtil.of("line");
    public static final String JSON_line_end = ObjectsUtil.of("line_end");
    public static final String JSON_attributes = ObjectsUtil.of("attributes");
    public static final String JSON_nodes = ObjectsUtil.of("nodes");
    public static final String JSON_value = ObjectsUtil.of("value");
    public static final String JSON_type = ObjectsUtil.of("type");

    ResXmlNode(Block chunk) {
        super(chunk);
    }

    Block getChunk() {
        return this.getBaseBlock();
    }

    @Override
    public ResXmlNode getParentNode() {
        return this.getParentInstance(ResXmlNode.class);
    }

    public Iterator<ResXmlNode> getParentNodes() {
        return new ParentNodeIterator(this.getParentNode());
    }

    <T extends ResXmlNode> Iterator<T> visitParentNodes(Class<T> instance, Class<? extends ResXmlNode> upperBound) {
        return InstanceIterator.of(new ParentNodeIterator(this, upperBound), instance);
    }

    public ResXmlNode getPrevious() {
        ResXmlNode parent = this.getParentNode();
        if (parent instanceof ResXmlNodeTree) {
            ResXmlNodeTree nodeTree = (ResXmlNodeTree)parent;
            return nodeTree.get(this.getIndex() - 1);
        }
        return null;
    }

    public ResXmlNode getNext() {
        ResXmlNode parent = this.getParentNode();
        if (parent instanceof ResXmlNodeTree) {
            ResXmlNodeTree nodeTree = (ResXmlNodeTree)parent;
            return nodeTree.get(this.getIndex() + 1);
        }
        return null;
    }

    abstract void onPreRemove();

    public boolean removeSelf() {
        throw new RuntimeException("Method not implemented");
    }

    abstract void linkStringReferences();

    public int getDepth() {
        return CollectionUtil.count(this.getParentNodes());
    }

    @Override
    public int getLineNumber() {
        return this.getStartLineNumber();
    }

    public int getStartLineNumber() {
        return 0;
    }

    public int getEndLineNumber() {
        return 0;
    }

    abstract Iterator<ResXmlEvent> getParserEvents();

    public void autoSetLineNumber() {
        this.autoSetLineNumber(1);
    }

    abstract int autoSetLineNumber(int var1);

    abstract String nodeTypeName();

    @Override
    public abstract JSONObject toJson();

    @Override
    public abstract void fromJson(JSONObject var1);

    @Override
    public void serialize(XmlSerializer serializer) throws IOException {
        this.serialize(serializer, true);
    }

    public abstract void serialize(XmlSerializer var1, boolean var2) throws IOException;

    void serializeComment(XmlSerializer serializer, String comment) throws IOException {
        if (comment != null) {
            serializer.comment(comment);
        }
    }

    @Override
    public abstract void parse(XmlPullParser var1) throws IOException, XmlPullParserException;

    public XmlPullParser getParser() {
        return new ResXmlEventParser(this.getParserEvents());
    }

    public XmlResourceParser getResourceParser() {
        return new ResXmlPullParser(this.getParserEvents());
    }

    public abstract XMLNode toXml(boolean var1);

    public boolean isDocument() {
        return false;
    }

    public boolean isElement() {
        return false;
    }

    public boolean isText() {
        return false;
    }

    public boolean isComment() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    ResXmlNode newSimilarTo(ResXmlNode otherNode) {
        throw new RuntimeException("Method not implemented");
    }

    public abstract void mergeWithName(ResourceMergeOption var1, ResXmlNode var2);

    public abstract void merge(ResXmlNode var1);

    static void setIndent(XmlSerializer serializer, boolean state) {
        try {
            serializer.setFeature(FEATURE_INDENT_OUTPUT, state);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static boolean isTextEvent(int event) {
        return event == 4 || event == 6 || event == 7 || event == 5;
    }

    static class ParentNodeIterator
    implements Iterator<ResXmlNode> {
        private ResXmlNode parentNode;
        private final Class<? extends ResXmlNode> upperBoundClass;

        public ParentNodeIterator(ResXmlNode parentNode, Class<? extends ResXmlNode> upperBoundClass) {
            if (parentNode != null && upperBoundClass != null && upperBoundClass.isInstance(parentNode)) {
                parentNode = null;
            }
            this.parentNode = parentNode;
            this.upperBoundClass = upperBoundClass;
        }

        public ParentNodeIterator(ResXmlNode parentNode) {
            this(parentNode, null);
        }

        @Override
        public boolean hasNext() {
            return this.parentNode != null;
        }

        @Override
        public ResXmlNode next() {
            ResXmlNode resXmlNode = this.parentNode;
            ResXmlNode parent = resXmlNode.getParentNode();
            Class<? extends ResXmlNode> upperBoundClass = this.upperBoundClass;
            if (parent != null && upperBoundClass != null && upperBoundClass.isInstance(parent)) {
                parent = null;
            }
            this.parentNode = parent;
            return resXmlNode;
        }
    }
}

