/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.chunk.xml;

import com.reandroid.arsc.chunk.xml.ResXmlElement;
import com.reandroid.arsc.chunk.xml.ResXmlEvent;
import com.reandroid.arsc.chunk.xml.ResXmlNode;
import com.reandroid.arsc.chunk.xml.ResXmlNodeTree;
import com.reandroid.arsc.chunk.xml.ResXmlTextChunk;
import com.reandroid.arsc.coder.XmlSanitizer;
import com.reandroid.arsc.refactor.ResourceMergeOption;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.base.Text;
import java.io.IOException;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ResXmlTextNode
extends ResXmlNode
implements Text {
    private String mIndentText;

    public ResXmlTextNode() {
        super(new ResXmlTextChunk());
    }

    public boolean isEmpty() {
        return StringsUtil.isEmpty(this.getText());
    }

    public boolean isBlank() {
        return StringsUtil.isBlank(this.getText());
    }

    @Override
    ResXmlTextChunk getChunk() {
        return (ResXmlTextChunk)super.getChunk();
    }

    public boolean isIndent() {
        return !this.hasComment() && ResXmlTextNode.isIndent(this.getText());
    }

    @Override
    int autoSetLineNumber(int start) {
        int lineNumber = start++;
        if (!this.isComment()) {
            String text = this.getText();
            if (ResXmlTextNode.isIndent(text) && this.isNextElement()) {
                ++lineNumber;
            } else {
                start += StringsUtil.countChar(text, '\n');
            }
        }
        this.setLineNumber(lineNumber);
        return start;
    }

    private boolean isNextElement() {
        ResXmlNodeTree parent = this.getParentNode();
        if (parent != null) {
            return parent.get(this.getIndex() + 1) instanceof ResXmlElement;
        }
        return false;
    }

    public String getComment() {
        return this.getChunk().getComment();
    }

    public void setComment(String comment) {
        this.getChunk().setComment(comment);
    }

    @Override
    Iterator<ResXmlEvent> getParserEvents() {
        if (this.isComment()) {
            return SingleIterator.of(ResXmlEvent.comment(this));
        }
        if (this.hasComment()) {
            return CombiningIterator.singleOne(ResXmlEvent.comment(this), SingleIterator.of(ResXmlEvent.text(this)));
        }
        return SingleIterator.of(ResXmlEvent.text(this));
    }

    @Override
    public ResXmlNodeTree getParentNode() {
        return (ResXmlNodeTree)super.getParentNode();
    }

    @Override
    public int getStartLineNumber() {
        return this.getChunk().getLineNumber();
    }

    @Override
    public int getEndLineNumber() {
        int line = this.getStartLineNumber();
        if (!this.isIndent()) {
            line += StringsUtil.countChar(this.getText(), '\n');
        }
        return line;
    }

    @Override
    public void setLineNumber(int lineNumber) {
        this.getChunk().setLineNumber(lineNumber);
    }

    @Override
    public String getText() {
        return this.getChunk().getText();
    }

    @Override
    public void setText(String text) {
        this.getChunk().setText(text);
        this.mIndentText = null;
    }

    public void append(String text) {
        String exist = this.getText();
        if (exist == null || exist.length() == 0) {
            exist = this.mIndentText;
        }
        if (exist == null && ResXmlTextNode.isIndent(text)) {
            this.mIndentText = text;
            return;
        }
        if (exist != null) {
            text = exist + text;
        }
        this.setText(text);
    }

    @Override
    public boolean isNull() {
        return this.getChunk().isNull();
    }

    @Override
    public boolean removeSelf() {
        ResXmlNodeTree parentNode = this.getParentNode();
        if (parentNode != null) {
            return parentNode.remove(this);
        }
        return false;
    }

    @Override
    void onPreRemove() {
        this.getChunk().onPreRemove();
    }

    @Override
    void linkStringReferences() {
        this.getChunk().linkStringReferences();
    }

    @Override
    public void serialize(XmlSerializer serializer, boolean decode) throws IOException {
        String text;
        this.serializeComment(serializer, this.getComment());
        if (this.isText() && (text = this.getText()) != null) {
            serializer.text(text);
        }
    }

    @Override
    public void parse(XmlPullParser parser) throws IOException, XmlPullParserException {
        this.setLineNumber(parser.getLineNumber());
        if (parser.getEventType() == 9) {
            this.setComment(parser.getText());
            parser.nextToken();
        } else {
            if (!ResXmlTextNode.isTextEvent(parser.getEventType())) {
                throw new XmlPullParserException("Expecting text events, but found: " + XMLUtil.toEventName(parser.getEventType()) + ", " + parser.getPositionDescription());
            }
            while (ResXmlTextNode.isTextEvent(parser.getEventType())) {
                this.append(XmlSanitizer.unEscapeUnQuote(parser.getText()));
                parser.nextToken();
            }
            if (this.isNull()) {
                this.removeSelf();
            }
        }
    }

    @Override
    public XMLNode toXml(boolean decode) {
        if (this.isComment()) {
            return new XMLComment(this.getComment());
        }
        return new XMLText(this.getText());
    }

    @Override
    public void merge(ResXmlNode xmlNode) {
        if (xmlNode == this) {
            return;
        }
        ResXmlTextNode coming = (ResXmlTextNode)xmlNode;
        this.setText(coming.getText());
        this.setComment(coming.getComment());
        this.setLineNumber(coming.getLineNumber());
    }

    @Override
    public void mergeWithName(ResourceMergeOption mergeOption, ResXmlNode xmlNode) {
        this.merge(xmlNode);
    }

    @Override
    public boolean isText() {
        return !this.isComment();
    }

    @Override
    public boolean isComment() {
        return this.hasComment() && this.isEmpty();
    }

    public boolean hasComment() {
        return !StringsUtil.isEmpty(this.getComment());
    }

    @Override
    String nodeTypeName() {
        if (this.isComment()) {
            return JSON_node_type_comment;
        }
        return JSON_node_type_text;
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(JSON_node_type, this.nodeTypeName());
        jsonObject.put(JSON_line, this.getLineNumber());
        if (this.isText()) {
            jsonObject.put(JSON_value, this.getText());
        }
        jsonObject.put(JSON_comment, this.getComment());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setText(json.optString(JSON_value, null));
        this.setComment(json.optString(JSON_comment, null));
        this.setLineNumber(json.optInt(JSON_line));
    }

    @Override
    public String toString() {
        if (this.isText()) {
            String text = this.getText();
            return text == null ? "null" : text;
        }
        return "<!--" + this.getComment() + "-->";
    }

    private static boolean isIndent(String text) {
        if (text == null) {
            return true;
        }
        int length = text.length();
        if (length == 0) {
            return true;
        }
        if (text.charAt(0) != '\n') {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            if (StringsUtil.isWhiteSpace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

