/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.CoderComplexData;
import com.reandroid.arsc.coder.ComplexUnit;
import com.reandroid.arsc.coder.ComplexUtil;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.UnitFraction;
import com.reandroid.arsc.value.ValueType;

public class CoderFraction
extends CoderComplexData {
    public static final CoderFraction INS = new CoderFraction();

    @Override
    public EncodeResult encode(String text) {
        int i = text.indexOf(37);
        if (i < 0) {
            return null;
        }
        ComplexUnit unit = this.parseUnit(text);
        if (unit == null) {
            return null;
        }
        String number = text.substring(0, text.length() - unit.getSymbol().length());
        Float floatValue = CoderFraction.parseFloat(number);
        if (floatValue == null) {
            return null;
        }
        int value = ComplexUtil.encodeComplex(floatValue.floatValue(), unit);
        return new EncodeResult(unit.getValueType(), value);
    }

    @Override
    ComplexUnit parseUnit(String text) {
        return UnitFraction.fromPostfix(text);
    }

    @Override
    public String decode(int data) {
        return ComplexUtil.decodeComplex(true, data);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.FRACTION;
    }
}

