/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.coder.Coder;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.utils.HexUtil;

public class CoderUnknownNameId
extends Coder {
    public static final CoderUnknownNameId INS = new CoderUnknownNameId();
    private static final char PREFIX_CHAR = 'r';
    private static final String PREFIX = "r0x";
    private static final int LENGTH = 11;

    @Override
    public EncodeResult encode(String text) {
        if (text == null || text.length() != 11 || !text.startsWith(PREFIX)) {
            return null;
        }
        Integer value = CoderUnknownNameId.parseHex(text.substring(1));
        if (value != null) {
            return new EncodeResult(this.getValueType(), value);
        }
        return null;
    }

    @Override
    public String decode(int data) {
        return HexUtil.toHex8(PREFIX, data);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.REFERENCE;
    }

    @Override
    boolean canStartWith(char first) {
        return first == 'r';
    }
}

