/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.coder;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.model.ResourceEntry;
import com.reandroid.arsc.value.ValueType;
import java.io.IOException;

public class ReferenceString {
    public final String prefix;
    public final String packageName;
    public final String type;
    public final String name;

    public ReferenceString(String prefix, String packageName, String type, String name) {
        this.prefix = prefix;
        this.packageName = packageName;
        this.type = type;
        this.name = name;
    }

    public EncodeResult encode(TableBlock tableBlock) {
        return this.encode(tableBlock, null);
    }

    public EncodeResult encode(TableBlock tableBlock, EncodeResult notFound) {
        ResourceEntry resourceEntry = tableBlock.getResource(this.packageName, this.type, this.name);
        if (resourceEntry != null) {
            return new EncodeResult(this.getValueType(), resourceEntry.getResourceId());
        }
        return notFound;
    }

    public EncodeResult encode(PackageBlock packageBlock) {
        return this.encode(packageBlock, null);
    }

    public EncodeResult encode(PackageBlock packageBlock, EncodeResult notFound) {
        ResourceEntry resourceEntry = packageBlock.getTableBlock().getResource(packageBlock, this.packageName, this.type, this.name);
        if (resourceEntry != null) {
            return new EncodeResult(this.getValueType(), resourceEntry.getResourceId());
        }
        return notFound;
    }

    public ValueType getValueType() {
        if ("?".equals(this.prefix)) {
            return ValueType.ATTRIBUTE;
        }
        return ValueType.REFERENCE;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.prefix != null) {
            builder.append(this.prefix);
        }
        if (this.packageName != null) {
            builder.append(this.packageName);
            builder.append(':');
        }
        if (this.type != null) {
            builder.append(this.type);
            builder.append('/');
        }
        builder.append(this.name);
        return builder.toString();
    }

    public static EncodeResult encodeReference(PackageBlock packageBlock, String text) throws IOException {
        return ReferenceString.encodeReference(packageBlock, text, null);
    }

    public static EncodeResult encodeReference(PackageBlock packageBlock, String text, EncodeResult errorResult) throws IOException {
        EncodeResult encodeResult = ValueCoder.encodeUnknownResourceId(text);
        if (encodeResult != null) {
            return encodeResult;
        }
        ReferenceString referenceString = ReferenceString.parseReference(text);
        if (referenceString == null) {
            return null;
        }
        encodeResult = referenceString.encode(packageBlock.getTableBlock());
        if (encodeResult == null) {
            if (errorResult != null) {
                return errorResult;
            }
            throw new IOException("Unknown reference: " + text);
        }
        return encodeResult;
    }

    public static ReferenceString parseReference(String ref) {
        String name;
        if (ref == null || ref.length() < 2 || ref.indexOf(47) < 0 || ref.indexOf(32) > 0) {
            return null;
        }
        char first = ref.charAt(0);
        if (first != '@' && first != '?') {
            return null;
        }
        int i = 1;
        if (ref.charAt(1) == '+') {
            i = 2;
        }
        String prefix = ref.substring(0, i);
        ref = ref.substring(i);
        String packageName = null;
        i = ref.indexOf(58);
        if (i > 0) {
            packageName = ref.substring(0, i);
            ref = ref.substring(++i);
        }
        if ((i = ref.indexOf(47)) < 0) {
            return null;
        }
        String type = ref.substring(0, i);
        if (!ReferenceString.isValidResourceName(name = ref.substring(++i))) {
            return null;
        }
        return new ReferenceString(prefix, packageName, type, name);
    }

    private static boolean isValidResourceName(String text) {
        char[] chars = text.toCharArray();
        int length = chars.length;
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (ReferenceString.isValidResourceName(chars[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidResourceName(char ch) {
        switch (ch) {
            case '\"': 
            case '*': 
            case '+': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '@': {
                return false;
            }
        }
        return true;
    }
}

