/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class AlignItem
extends BlockItem {
    private byte fill;
    private int alignment;
    private final boolean readable;
    private static final int ALIGNMENT = 4;

    public AlignItem(int alignment, boolean readable) {
        super(0);
        this.alignment = alignment;
        this.readable = readable;
    }

    public AlignItem(int alignment) {
        this(alignment, false);
    }

    public AlignItem(boolean readable) {
        this(4, readable);
    }

    public AlignItem() {
        this(4, false);
    }

    public int align(Block block) {
        this.clear();
        if (this.getAlignment() <= 0) {
            return 0;
        }
        return this.align(block.countBytes());
    }

    public int align(long count) {
        int size = AlignItem.align(this.getAlignment(), count);
        this.setSize(size);
        return size;
    }

    public int align(int count) {
        int size = AlignItem.align(this.getAlignment(), count);
        this.setSize(size);
        return size;
    }

    public void alignSafe(BlockReader reader) throws IOException {
        this.align(reader.getPosition());
        int size = this.size();
        int available = reader.available();
        if (size != 0 && available >= size) {
            reader.readFully(this.getBytesInternal(), 0, size);
        }
    }

    public void clear() {
        this.setBytesLength(0, false);
    }

    public int size() {
        return this.countBytes();
    }

    public void ensureSize(int size) {
        if (size > this.size()) {
            this.setSize(size);
        }
    }

    public void setSize(int size) {
        this.setBytesLength(size, false);
        this.setFill(this.fill);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        if (alignment <= 0) {
            this.setBytesLength(0, false);
        }
    }

    public byte getFill() {
        return this.fill;
    }

    public void setFill(byte fill) {
        this.fill = fill;
        byte[] bytes = this.getBytesInternal();
        int length = bytes.length;
        for (int i = 0; i < length; ++i) {
            bytes[i] = fill;
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        if (this.readable) {
            this.alignSafe(reader);
        } else {
            super.onReadBytes(reader);
        }
    }

    public String toString() {
        int alignment = this.getAlignment();
        if (alignment <= 0) {
            return "OFF";
        }
        int size = this.size();
        byte fill = this.fill;
        StringBuilder builder = new StringBuilder();
        if (alignment != 4) {
            builder.append("alignment=");
            builder.append(alignment);
            builder.append(", ");
        }
        if (fill != 0) {
            builder.append("fill=");
            builder.append(HexUtil.toHex2(fill));
            builder.append(", ");
        }
        builder.append("align=");
        builder.append(size);
        return builder.toString();
    }

    public static int align(int alignment, long value) {
        if (alignment <= 1) {
            return 0;
        }
        return (alignment - (int)(value % (long)alignment)) % alignment;
    }

    public static int align(int alignment, int value) {
        if (alignment <= 1) {
            return 0;
        }
        return (alignment - value % alignment) % alignment;
    }
}

