/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.base.DirectStreamReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.utils.HexUtil;

public class ByteItem
extends BlockItem
implements IntegerReference,
DirectStreamReader {
    public static final Creator<ByteItem> CREATOR = ByteItem::new;

    public ByteItem() {
        super(1);
    }

    public boolean getBit(int index) {
        return (this.getByte() >> index & 1) == 1;
    }

    public void putBit(int index, boolean bit) {
        int val = this.getByte();
        int left = val >> index;
        left = bit ? (left |= 1) : (left &= 0xFE);
        left <<= index;
        index = 8 - index;
        int right = 255 >> index & val;
        val = left | right;
        this.set((byte)val);
    }

    public void set(byte value) {
        this.getBytesInternal()[0] = value;
    }

    public byte getByte() {
        return this.getBytesInternal()[0];
    }

    @Override
    public int get() {
        return this.getByte() & 0xFF;
    }

    @Override
    public void set(int value) {
        this.set((byte)value);
    }

    public String toHex() {
        return HexUtil.toHex2(this.getByte());
    }

    public String toString() {
        return String.valueOf(this.getByte());
    }
}

