/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.base.DirectStreamReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.utils.HexUtil;

public class IntegerItem
extends BlockItem
implements ReferenceItem,
DirectStreamReader {
    private final boolean bigEndian;
    private int mCache;
    public static final Creator<IntegerItem> CREATOR = () -> new IntegerItem(false);
    public static final Creator<IntegerItem> CREATOR_BIG_ENDIAN = () -> new IntegerItem(true);

    public IntegerItem(boolean bigEndian) {
        super(4);
        this.bigEndian = bigEndian;
    }

    public IntegerItem() {
        this(false);
    }

    public IntegerItem(int value) {
        this(false);
        this.set(value);
    }

    @Override
    public void set(int value) {
        if (value == this.mCache) {
            return;
        }
        this.mCache = value;
        byte[] bytes = this.getBytesInternal();
        if (this.bigEndian) {
            IntegerItem.putBigEndianInteger(bytes, 0, value);
        } else {
            IntegerItem.putInteger(bytes, 0, value);
        }
    }

    @Override
    public int get() {
        return this.mCache;
    }

    @Override
    public <T1 extends Block> T1 getReferredParent(Class<T1> parentClass) {
        return (T1)((Block)this.getParentInstance(parentClass));
    }

    public long unsignedLong() {
        return (long)this.get() & 0xFFFFFFFFL;
    }

    public String toHex() {
        return HexUtil.toHex8(this.get());
    }

    @Override
    protected void onBytesChanged() {
        byte[] bytes = this.getBytesInternal();
        int i = this.bigEndian ? IntegerItem.getBigEndianInteger(bytes, 0) : IntegerItem.getInteger(bytes, 0);
        this.mCache = i;
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

