/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.LongReference;
import com.reandroid.utils.NumberX;

public class NumberBlock
extends BlockItem
implements LongReference {
    public NumberBlock(int width) {
        super(width);
    }

    @Override
    public long getLong() {
        int width = this.width();
        if (width > 8) {
            width = 8;
        }
        return NumberX.valueOfUnsigned(width, this.unsigned()).longValue();
    }

    @Override
    public void set(long value) {
        byte[] bytes = this.getBytesInternal();
        int length = bytes.length;
        this.validate(length, value);
        NumberBlock.putNumber(bytes, 0, length, value);
    }

    @Override
    public int get() {
        return (int)this.getLong();
    }

    @Override
    public void set(int value) {
        this.set((long)value);
    }

    public int width() {
        return this.countBytes();
    }

    public void width(int width) {
        if (width == this.width()) {
            return;
        }
        long value = this.getLong();
        this.setBytesLength(width, false);
        this.set(value);
    }

    private long unsigned() {
        byte[] bytes = this.getBytesInternal();
        return NumberBlock.getUnsignedNumber(bytes, 0, bytes.length);
    }

    private void validate(int width, long value) {
        if (value != 0L) {
            if (width == 0) {
                throw new NumberFormatException("Width == 0 for value = " + value);
            }
            if (value < 0L && value < NumberX.minValueForWidth(width) || value > 0L && value > NumberX.maxValueForWidth(width)) {
                throw new NumberFormatException("Out of range for width = " + width + ", value = " + value);
            }
        }
    }

    public String toHexString() {
        return NumberX.toHexString(this.width(), this.getLong());
    }

    public String toString() {
        return this.toHexString();
    }
}

