/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.base.DirectStreamReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.utils.HexUtil;

public class ShortItem
extends BlockItem
implements IntegerReference,
DirectStreamReader {
    private final boolean bigEndian;
    private int mCache;
    public static final Creator<ShortItem> CREATOR = () -> new ShortItem(false);
    public static final Creator<ShortItem> CREATOR_BIG_ENDIAN = () -> new ShortItem(true);

    public ShortItem(boolean bigEndian) {
        super(2);
        this.bigEndian = bigEndian;
    }

    public ShortItem() {
        this(false);
    }

    public ShortItem(short value) {
        this(false);
        this.set(value);
    }

    @Override
    public void set(int value) {
        if (value == this.mCache) {
            return;
        }
        this.mCache = value;
        byte[] bytes = this.getBytesInternal();
        if (this.bigEndian) {
            ShortItem.putBigEndianShort(bytes, 0, value);
        } else {
            ShortItem.putShort(bytes, 0, value);
        }
    }

    @Override
    public int get() {
        return this.mCache;
    }

    public void set(short value) {
        this.set(0xFFFF & value);
    }

    public int unsignedInt() {
        return this.get();
    }

    public short getShort() {
        return (short)this.mCache;
    }

    public String toHex() {
        return HexUtil.toHex4(this.getShort());
    }

    @Override
    protected void onBytesChanged() {
        byte[] bytes = this.getBytesInternal();
        int s = this.bigEndian ? ShortItem.getBigEndianShort(bytes, 0) : ShortItem.getShortUnsigned(bytes, 0);
        this.mCache = s;
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

