/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.list;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.header.TypeHeader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.OffsetItem;
import com.reandroid.arsc.list.EntryItemList;
import com.reandroid.arsc.list.OffsetReferenceList;
import com.reandroid.arsc.value.Entry;
import com.reandroid.utils.collection.ArrayCollection;
import java.util.List;

public class EntryItemOffsetList
extends OffsetReferenceList<OffsetItem> {
    public EntryItemOffsetList(IntegerReference countReference) {
        super(countReference, OffsetItem.CREATOR_OFFSET32);
    }

    public int getHighestIdx() {
        int result = -1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int idx = ((OffsetItem)this.get(i)).getIdx();
            if (idx <= result) continue;
            result = idx;
        }
        return result;
    }

    public int indexOfIdx(int idx) {
        int result = -1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (idx != ((OffsetItem)this.get(i)).getIdx()) continue;
            return i;
        }
        return result;
    }

    public int findSortPoint(int idx) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (idx <= ((OffsetItem)this.get(i)).getIdx()) continue;
            return i;
        }
        return size;
    }

    public boolean isSparse() {
        return this.getCreator() == OffsetItem.CREATOR_SPARSE;
    }

    public int getOffsetType() {
        Creator creator = this.getCreator();
        if (creator == OffsetItem.CREATOR_OFFSET16) {
            return TypeHeader.OFFSET_16;
        }
        if (creator == OffsetItem.CREATOR_SPARSE) {
            return TypeHeader.OFFSET_SPARSE;
        }
        return TypeHeader.OFFSET_32;
    }

    public boolean setOffsetType(int offsetType, EntryItemList entryItemList) {
        if (offsetType != this.getOffsetType()) {
            if (offsetType == TypeHeader.OFFSET_SPARSE) {
                this.changeToSparse(entryItemList);
            } else if (this.isSparse()) {
                if (offsetType == TypeHeader.OFFSET_16) {
                    this.changeFromSparse(entryItemList, OffsetItem.CREATOR_OFFSET16);
                } else {
                    this.changeFromSparse(entryItemList, OffsetItem.CREATOR_OFFSET32);
                }
            } else {
                if (offsetType == TypeHeader.OFFSET_16) {
                    this.setCreator(OffsetItem.CREATOR_OFFSET16);
                } else {
                    this.setCreator(OffsetItem.CREATOR_OFFSET32);
                }
                if (!entryItemList.isEmpty()) {
                    this.clear();
                }
            }
            return !entryItemList.isEmpty();
        }
        return false;
    }

    private void changeFromSparse(EntryItemList entryItemList, Creator<? extends OffsetItem> creator) {
        if (entryItemList.isEmpty()) {
            this.setCreator(creator);
        } else {
            entryItemList.sort();
            List<Integer> idList = this.listIds(entryItemList);
            int size = idList.size();
            int largest = idList.get(size - 1);
            this.clear();
            this.setCreator(creator);
            int index = 0;
            for (int i = 0; i < size; ++i) {
                int id = idList.get(i);
                for (int j = index + 1; j < id; ++j) {
                    entryItemList.createAt(j);
                }
                index = id;
            }
            entryItemList.setSize(largest + 1);
            this.setSize(entryItemList.size());
        }
    }

    private void changeToSparse(EntryItemList entryItemList) {
        if (entryItemList.isEmpty()) {
            this.setCreator(OffsetItem.CREATOR_SPARSE);
        } else {
            List<Integer> idList = this.listIds(entryItemList);
            int size = idList.size();
            this.clear();
            this.setCreator(OffsetItem.CREATOR_SPARSE);
            this.setSize(size);
            for (int i = 0; i < size; ++i) {
                Integer id = idList.get(i);
                OffsetItem offsetItem = (OffsetItem)this.get(i);
                offsetItem.setIdx(id);
            }
            entryItemList.removeIf(Entry::isNull);
        }
    }

    private List<Integer> listIds(EntryItemList entryItemList) {
        int size = entryItemList.size();
        ArrayCollection<Integer> list = new ArrayCollection<Integer>(size);
        for (int i = 0; i < size; ++i) {
            Entry entry = (Entry)entryItemList.get(i);
            if (entry.isNull()) continue;
            list.add(entry.getId());
        }
        return list;
    }
}

