/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.list;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.base.DirectStreamReader;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.OffsetItem;
import java.io.IOException;
import java.io.InputStream;

public class OffsetReferenceList<T extends OffsetItem>
extends BlockList<T>
implements DirectStreamReader {
    private final IntegerReference countReference;

    public OffsetReferenceList(IntegerReference countReference, Creator<? extends T> creator) {
        super(creator);
        this.countReference = countReference;
    }

    public IntegerReference getCountReference() {
        return this.countReference;
    }

    public void clear() {
        this.clearChildes();
    }

    @Override
    public void setSize(int size) {
        super.setSize(size);
        this.getCountReference().set(size);
    }

    @Override
    protected boolean hasSimilarEntries() {
        return true;
    }

    @Override
    protected void refreshChildes() {
    }

    @Override
    protected void onReadBytes(BlockReader reader) throws IOException {
        int size = this.getCountReference().get();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            ((OffsetItem)this.get(i)).readBytes(reader);
        }
    }

    @Override
    public int readBytes(InputStream inputStream) throws IOException {
        int size = this.getCountReference().get();
        this.setSize(size);
        int count = 0;
        for (int i = 0; i < size; ++i) {
            count += ((OffsetItem)this.get(i)).readBytes(inputStream);
        }
        return count;
    }
}

