/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.list;

import com.reandroid.arsc.chunk.xml.ResXmlDocumentChunk;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ResXmlID;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.utils.CompareUtil;
import java.util.Comparator;
import java.util.Iterator;

public class ResXmlIDList
extends CountedBlockList<ResXmlID> {
    public ResXmlIDList(IntegerReference countReference) {
        super(ResXmlID.CREATOR, countReference);
    }

    public ResXmlID getOrCreate(int resourceId) {
        ResXmlID id = (ResXmlID)this.get(resourceId);
        if (id == null) {
            id = (ResXmlID)this.createNext();
            id.set(resourceId);
        }
        return id;
    }

    public ResXmlID getId(int resourceId) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ResXmlID id = (ResXmlID)this.get(i);
            if (resourceId != id.get()) continue;
            return id;
        }
        return null;
    }

    @Override
    public void setSize(int size, boolean notify) {
        super.setSize(size, true);
    }

    @Override
    public int countBytes() {
        int count = this.size();
        if (count != 0) {
            count *= ((ResXmlID)this.get(0)).countBytes();
        }
        return count;
    }

    public void clear() {
        super.clearChildes();
    }

    @Override
    protected boolean hasSimilarEntries() {
        return true;
    }

    public boolean sort() {
        return this.sort(CompareUtil.getComparableComparator());
    }

    @Override
    public boolean sort(Comparator<? super ResXmlID> comparator) {
        boolean sorted = super.sort(comparator);
        if (this.adjustIndexes() && super.sort(comparator)) {
            sorted = true;
        }
        this.trimLastIf(ResXmlID::isEmpty);
        return sorted;
    }

    private boolean adjustIndexes() {
        Iterator iterator = this.clonedIterator();
        boolean adjusted = false;
        while (iterator.hasNext()) {
            int index;
            ResXmlID xmlID = (ResXmlID)iterator.next();
            ResXmlString stringItem = xmlID.getResXmlString();
            if (stringItem == null || (index = stringItem.getIndex()) == xmlID.getIndex()) continue;
            this.moveTo(xmlID, index);
            adjusted = true;
        }
        if (adjusted) {
            this.getParentInstance(ResXmlDocumentChunk.class).getStringPool().linkResXmlIDMapInternal();
        }
        return adjusted;
    }
}

