/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.list;

import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.base.BlockLocator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.header.StringPoolHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.AlignItem;
import com.reandroid.arsc.item.StringCreator;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.list.OffsetBlockList;
import com.reandroid.arsc.list.OffsetReferenceList;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;
import java.util.Comparator;

public class StringItemList<T extends StringItem>
extends OffsetBlockList<T>
implements JSONConvert<JSONArray> {
    private final AlignItem alignment;
    private final StringPoolHeader header;
    private int mBytesCount;
    private boolean mSortRequired;

    public StringItemList(AlignItem alignment, StringPoolHeader header, OffsetReferenceList<?> offsetReferenceList, StringCreator<? extends T> stringCreator) {
        super(header.getStartStrings(), offsetReferenceList);
        this.alignment = alignment;
        this.header = header;
        header.setEncodingChangedListener(this::onStringEncodingChanged);
        this.setCreator(() -> stringCreator.newInstance(header.isUtf8()));
    }

    public boolean isUtf8() {
        return this.header.isUtf8();
    }

    public void setUtf8(boolean utf8) {
        this.header.setUtf8(utf8);
    }

    void onStringEncodingChanged(boolean utf8) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((StringItem)this.get(i)).setUtf8(utf8);
        }
        this.resetCountBytes();
    }

    @Override
    public void onPreRemove(T block) {
        StringPool<T> stringPool = this.getStringPool();
        stringPool.onStringRemoved(block);
        ((StringItem)block).onRemoved();
        super.onPreRemove(block);
        this.resetCountBytes();
        this.mSortRequired = true;
    }

    public void sort() {
        this.sort(CompareUtil.getComparableComparator());
    }

    @Override
    public boolean sort(Comparator<? super T> comparator) {
        this.mSortRequired = false;
        boolean sorted = super.sort(comparator);
        StringPool<T> stringPool = this.getStringPool();
        if (stringPool != null) {
            stringPool.onSortedInternal();
        }
        this.mSortRequired = false;
        return sorted;
    }

    @Override
    public void add(int index, T item) {
        this.getStringPool().onPreAddInternal(index, item);
        super.add(index, item);
    }

    private StringPool<T> getStringPool() {
        return (StringPool)ObjectsUtil.cast(this.getParentInstance(StringPool.class));
    }

    @Override
    public AlignItem getAlignment() {
        return this.alignment;
    }

    @Override
    public int buildOffsetList() {
        int count = super.buildOffsetList();
        this.mBytesCount = count - this.getAlignment().size();
        return count;
    }

    public void onStringChanged(String old, T stringItem) {
        StringPool<T> stringPool = this.getStringPool();
        if (stringPool != null) {
            this.resetCountBytes();
            stringPool.onStringChanged(old, stringItem);
        }
        this.mSortRequired = true;
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        if (this.mSortRequired) {
            this.sort();
        }
    }

    @Override
    public int countBytes() {
        int count = this.mBytesCount;
        if (count == 0 && this.size() != 0) {
            this.mBytesCount = count = super.countBytes();
        }
        return count;
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        counter.setCurrent(this);
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        if (counter.END instanceof StringItem || counter instanceof BlockLocator) {
            super.onCountUpTo(counter);
            return;
        }
        counter.addCount(this.countBytes());
    }

    private void resetCountBytes() {
        this.mBytesCount = 0;
    }

    @Override
    public void readChildes(BlockReader reader) throws IOException {
        super.readChildes(reader);
        this.resetCountBytes();
        this.mSortRequired = false;
    }

    public boolean isSortRequired() {
        return this.mSortRequired;
    }

    @Override
    public JSONArray toJson() {
        return BlockList.toJsonArray(this);
    }

    @Override
    public void fromJson(JSONArray json) {
        if (json != null) {
            int start = this.size();
            int length = json.length();
            this.setSize(start + length);
            for (int i = 0; i < length; ++i) {
                ((StringItem)this.get(start + i)).fromJson(json.getJSONObject(i));
            }
        }
    }
}

