/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.list;

import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class StyleItemListEnd
extends BlockItem
implements BlockRefresh {
    private final IntegerReference stylesCount;

    public StyleItemListEnd(IntegerReference stylesCount) {
        super(0);
        this.stylesCount = stylesCount;
    }

    private boolean updateSize() {
        int size = this.stylesCount.get() != 0 ? 8 : 0;
        this.setBytesLength(size, false);
        if (size != 0) {
            int b = -1;
            byte[] bytes = this.getBytesInternal();
            for (int i = 0; i < size; ++i) {
                bytes[i] = b;
            }
            return true;
        }
        return false;
    }

    @Override
    public void refresh() {
        this.updateSize();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        if (this.updateSize()) {
            super.onReadBytes(reader);
        }
    }

    public String toString() {
        return HexUtil.toHexString(this.getBytesInternal());
    }
}

