/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.pool;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.header.StringPoolHeader;
import com.reandroid.arsc.item.AlignItem;
import com.reandroid.arsc.item.OffsetItem;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.StringCreator;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.arsc.list.OffsetReferenceList;
import com.reandroid.arsc.list.StringItemList;
import com.reandroid.arsc.list.StyleItemList;
import com.reandroid.arsc.list.StyleItemListEnd;
import com.reandroid.common.BytesOutputStream;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.NumbersUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.MultiMap;
import com.reandroid.xml.StyleDocument;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public abstract class StringPool<T extends StringItem>
extends Chunk<StringPoolHeader>
implements Iterable<T>,
JSONConvert<JSONArray> {
    private final Object mLock = new Object();
    private final StringItemList<T> mArrayStrings;
    private final StyleItemList mArrayStyles;
    private final MultiMap<String, T> poolMap;
    private boolean stringLinkLocked;

    StringPool(boolean is_utf8, boolean stringLinkLocked, StringCreator<T> creator) {
        super(new StringPoolHeader(), 6);
        StringPoolHeader header = (StringPoolHeader)this.getHeaderBlock();
        header.setEncodingChangedListener(null);
        header.setUtf8(is_utf8);
        OffsetReferenceList<OffsetItem> offsetStrings = new OffsetReferenceList<OffsetItem>(header.getCountStrings(), OffsetItem.CREATOR_OFFSET32);
        OffsetReferenceList<OffsetItem> offsetStyles = new OffsetReferenceList<OffsetItem>(header.getCountStyles(), OffsetItem.CREATOR_OFFSET32);
        AlignItem stringsAlign = new AlignItem(true);
        this.mArrayStrings = new StringItemList<T>(stringsAlign, header, offsetStrings, creator);
        this.mArrayStyles = new StyleItemList(header.getStartStyles(), offsetStyles);
        StyleItemListEnd styleItemListEnd = new StyleItemListEnd(header.getCountStyles());
        this.addChild(offsetStrings);
        this.addChild(offsetStyles);
        this.addChild(this.mArrayStrings);
        this.addChild(stringsAlign);
        this.addChild(this.mArrayStyles);
        this.addChild(styleItemListEnd);
        this.stringLinkLocked = stringLinkLocked;
        this.poolMap = new MultiMap();
        this.poolMap.setFavouriteObjectsSorter((item1, item2) -> {
            int i = item1.compareTo((StringItem)item2);
            if (i == 0) {
                i = CompareUtil.compareUnsigned(item1.getIndex(), item2.getIndex());
            }
            return i;
        });
    }

    StringPool(boolean is_utf8, StringCreator<T> creator) {
        this(is_utf8, true, creator);
    }

    @Override
    public Iterator<T> iterator() {
        return this.mArrayStrings.iterator();
    }

    public final T get(int index) {
        return (T)((StringItem)this.mArrayStrings.get(index));
    }

    public int size() {
        return this.mArrayStrings.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.getStyleArray().clear();
        this.getStringsArray().clear();
        this.poolMap.clear();
    }

    public void sort() {
        this.ensureStringLinkUnlockedInternal();
        this.getStringsArray().sort();
    }

    public boolean isStringLinkLocked() {
        return this.stringLinkLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureStringLinkUnlockedInternal() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.stringLinkLocked) {
                return;
            }
            this.stringLinkLocked = false;
            this.linkStrings();
            this.reloadPoolMap();
        }
    }

    void linkStrings() {
        this.getStyleArray().linkStyleStringsInternal();
    }

    public void linkStylesInternal() {
        StyleItemList styleArray = this.getStyleArray();
        StringItemList<T> stringsArray = this.getStringsArray();
        int size = NumbersUtil.min(stringsArray.size(), styleArray.size());
        for (int i = 0; i < size; ++i) {
            StyleItem styleItem = (StyleItem)styleArray.get(i);
            StringItem stringItem = (StringItem)stringsArray.get(i);
            stringItem.linkStyleItemInternal(styleItem);
        }
        this.getStyleArray().linkStyleStringsInternal();
    }

    public void removeString(T item) {
        this.getStringsArray().remove(item);
    }

    public Iterator<String> getStrings() {
        return ComputeIterator.of(this.iterator(), StringItem::getXml);
    }

    public void addStrings(Collection<String> stringList) {
        if (stringList == null || stringList.size() == 0) {
            return;
        }
        for (String str : stringList) {
            this.createNewString(str);
        }
    }

    private void reloadPoolMap() {
        if (this.poolMap.size() == 0) {
            this.poolMap.clear();
            this.poolMap.setInitialSize(this.size());
            this.poolMap.putAll(StringItem::getXml, this.iterator());
        }
    }

    public void compressDuplicates() {
        this.ensureStringLinkUnlockedInternal();
        this.poolMap.findDuplicates(CompareUtil.getComparableComparator(), list -> {
            StringItem first = (StringItem)list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                StringItem item = (StringItem)list.get(i);
                first.transferReferences(item);
            }
        });
    }

    public boolean removeUnusedStrings() {
        return this.getStringsArray().removeIf(this.getUnusedStringsFilter());
    }

    public List<T> listUnused() {
        return this.getStringsArray().subListIf(this.getUnusedStringsFilter());
    }

    public int countUnused() {
        return this.getStringsArray().countIf(this.getUnusedStringsFilter());
    }

    private Predicate<T> getUnusedStringsFilter() {
        return item -> !item.hasReference();
    }

    public StyleItemList getStyleArray() {
        return this.mArrayStyles;
    }

    public StringItemList<T> getStringsArray() {
        return this.mArrayStrings;
    }

    public T removeReference(ReferenceItem ref) {
        if (ref == null) {
            return null;
        }
        T item = this.get(ref.get());
        if (item != null) {
            ((StringItem)item).removeReference(ref);
            return item;
        }
        return null;
    }

    public boolean contains(String str) {
        return this.poolMap.containsKey(str);
    }

    public void onStringChanged(String old, T stringItem) {
        if (!this.stringLinkLocked) {
            this.poolMap.updateKey(old, ((StringItem)stringItem).getXml(), stringItem);
        }
    }

    public void onStringRemoved(T stringItem) {
        if (!this.stringLinkLocked) {
            this.poolMap.remove(((StringItem)stringItem).getXml(), stringItem);
        }
    }

    public final T getLast() {
        return (T)((StringItem)this.mArrayStrings.getLast());
    }

    public <E extends Block> Iterator<E> getUsers(final Class<E> parentClass, String value) {
        return new IterableIterator<T, E>(this.getAll(value)){

            @Override
            public Iterator<E> iterator(T element) {
                return ((StringItem)element).getUsers(parentClass);
            }
        };
    }

    public final Iterator<T> getAll(String str) {
        this.ensureStringLinkUnlockedInternal();
        if (str == null) {
            return FilterIterator.of(this.poolMap.getAll(StringsUtil.EMPTY), Block::isNull);
        }
        return this.poolMap.getAll(str);
    }

    public final T get(String str, Predicate<? super T> predicate) {
        this.ensureStringLinkUnlockedInternal();
        if (str == null) {
            str = StringsUtil.EMPTY;
        }
        return (T)((StringItem)this.poolMap.get(str, predicate));
    }

    public final T getString(String str) {
        return (T)((StringItem)CollectionUtil.getFirst(this.getAll(str)));
    }

    public T getOrCreate(String str) {
        this.ensureStringLinkUnlockedInternal();
        StringItem item = this.get(str, stringItem -> stringItem.equalsValue(str));
        if (item == null) {
            item = this.createNewString(str);
        }
        return (T)item;
    }

    public T getOrCreate(StyleDocument styleDocument) {
        this.ensureStringLinkUnlockedInternal();
        String xml = styleDocument.getXml();
        StringItem item = this.get(xml, StringItem::hasStyle);
        if (item != null) {
            return (T)item;
        }
        item = this.createNewString();
        item.set(styleDocument);
        return (T)item;
    }

    public T getOrCreate(JSONObject jsonObject) {
        this.ensureStringLinkUnlockedInternal();
        JSONObject style = jsonObject.optJSONObject(StringItem.NAME_style);
        if (style != null) {
            T item = this.createNewString();
            ((StringItem)item).set(jsonObject);
            StyleDocument styleDocument = ((StringItem)item).getStyleDocument();
            if (styleDocument != null) {
                T exist = this.getString(styleDocument.getXml());
                if (exist != null) {
                    if (((StringItem)item).hasReference()) {
                        ((StringItem)item).set((String)null);
                        ((Block)item).setNull(true);
                    }
                    return exist;
                }
                return item;
            }
        }
        return this.getOrCreate(jsonObject.getString(StringItem.NAME_string));
    }

    public T createNewString(String str) {
        T item = this.createNewString();
        ((StringItem)item).set(str);
        return item;
    }

    public T createNewString() {
        return (T)((StringItem)this.mArrayStrings.createNext());
    }

    public final int countStyles() {
        return this.mArrayStyles.size();
    }

    public boolean isUtf8() {
        return ((StringPoolHeader)this.getHeaderBlock()).isUtf8();
    }

    public void setUtf8(boolean utf8) {
        ((StringPoolHeader)this.getHeaderBlock()).setUtf8(utf8);
    }

    public String getEncoding() {
        if (this.isUtf8()) {
            return "utf-8";
        }
        return "utf-16";
    }

    public void setEncoding(String encoding) {
        this.setUtf8(encoding != null && !StringsUtil.toLowercase(encoding).startsWith("utf-16"));
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.ensureStringLinkUnlockedInternal();
    }

    @Override
    protected void onChunkRefreshed() {
    }

    @Override
    public void onChunkLoaded() {
        this.linkStylesInternal();
        this.reloadPoolMap();
    }

    public void onPreAddInternal(int index, T item) {
    }

    public void onSortedInternal() {
        this.getStyleArray().sort();
    }

    @Override
    public byte[] getBytes() {
        BytesOutputStream outputStream = new BytesOutputStream(((StringPoolHeader)this.getHeaderBlock()).getChunkSize());
        try {
            this.writeBytes(outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return outputStream.toByteArray();
    }

    @Override
    public JSONArray toJson() {
        return this.getStringsArray().toJson();
    }

    @Override
    public void fromJson(JSONArray json) {
        if (json == null) {
            return;
        }
        this.getStringsArray().fromJson(json);
        this.refresh();
    }

    private boolean containsInternal(T item) {
        return this.poolMap.containsValue(((StringItem)item).getXml(), stringItem -> stringItem.compareTo((StringItem)item) == 0);
    }

    public void merge(StringPool<T> stringPool) {
        if (stringPool == null || stringPool == this || stringPool.isEmpty()) {
            return;
        }
        this.ensureStringLinkUnlockedInternal();
        for (StringItem stringItem : stringPool) {
            if (this.containsInternal(stringItem)) continue;
            ((StringItem)this.createNewString()).merge(stringItem);
        }
    }
}

