/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.item.ByteArray;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.value.ResConfigBase;

class ResConfigValueContainer
extends ByteArray {
    private final IntegerItem configSize;

    ResConfigValueContainer(int bytesSize, IntegerItem configSize) {
        super(bytesSize);
        this.configSize = configSize;
    }

    int getByteValue(int offset) {
        return this.getValue(offset, 1);
    }

    void setByteValue(int offset, int value) {
        this.setValue(offset, 1, value);
    }

    int getShortValue(int offset) {
        return this.getValue(offset, 2);
    }

    void setShortValue(int offset, int value) {
        this.setValue(offset, 2, value);
    }

    int getIntValue(int offset) {
        return this.getValue(offset, 4);
    }

    long getLongValue(int offset) {
        return ResConfigValueContainer.getLong(this.getBytesInternal(), offset);
    }

    void setIntValue(int offset, int value) {
        this.setValue(offset, 4, value);
    }

    void setByteArrayValue(int offset, byte[] bytes, int length) {
        if ((bytes == null || bytes.length == 0) && this.size() - offset < length) {
            return;
        }
        bytes = ResConfigValueContainer.ensureArrayLength(bytes, length);
        this.setValue(offset, bytes);
    }

    byte[] getByteArrayValue(int offset, int length) {
        int size = this.size();
        int available = size - offset;
        if (available < length || available <= 0) {
            return null;
        }
        return this.getByteArray(offset, length);
    }

    private int getValue(int offset, int dataSize) {
        int size = this.size();
        if (size < offset + dataSize) {
            return 0;
        }
        if (dataSize == 1) {
            return this.getByteUnsigned(offset);
        }
        if (dataSize == 2) {
            return this.getShortUnsigned(offset) & 0xFFFF;
        }
        if (dataSize == 4) {
            return this.getInteger(offset);
        }
        throw new IllegalArgumentException("Invalid data size " + dataSize);
    }

    private void setValue(int offset, byte[] bytes) {
        int size = this.size();
        int valueSize = offset + bytes.length;
        boolean sizeChanged = false;
        if (size < valueSize) {
            if (ResConfigValueContainer.isNullBytes(bytes)) {
                return;
            }
            this.ensureArraySize(ResConfigValueContainer.getNearestValueSize(valueSize));
            this.configSize.set(this.size() + 4);
            sizeChanged = true;
        }
        this.putByteArray(offset, bytes);
        if (sizeChanged) {
            this.onSizeChanged();
        }
    }

    private void setValue(int offset, int dataSize, int value) {
        boolean valueChanged;
        int size = this.size();
        int valueSize = offset + dataSize;
        boolean sizeChanged = false;
        if (size < valueSize) {
            if (value == 0) {
                return;
            }
            this.ensureArraySize(ResConfigValueContainer.getNearestValueSize(valueSize));
            this.configSize.set(this.size() + 4);
            sizeChanged = true;
        }
        if (dataSize == 1) {
            valueChanged = this.putByteValue(offset, (byte)value);
        } else if (dataSize == 2) {
            valueChanged = this.putShortValue(offset, value);
        } else if (dataSize == 4) {
            valueChanged = this.putIntegerValue(offset, value);
        } else {
            throw new IllegalArgumentException("Invalid data size " + dataSize);
        }
        if (sizeChanged) {
            this.onSizeChanged();
        }
        if (valueChanged) {
            this.onValueChanged();
        }
    }

    private boolean putByteValue(int offset, byte value) {
        if (this.get(offset) == value) {
            return false;
        }
        this.put(offset, value);
        return true;
    }

    private boolean putShortValue(int offset, int value) {
        if (this.getShortUnsigned(offset) == value) {
            return false;
        }
        this.putShort(offset, value);
        return true;
    }

    private boolean putIntegerValue(int offset, int value) {
        if (this.getInteger(offset) == value) {
            return false;
        }
        this.putInteger(offset, value);
        return true;
    }

    void onSizeChanged() {
    }

    void onValueChanged() {
    }

    private static int getNearestValueSize(int valueSize) {
        return ResConfigBase.nearestSize(valueSize + 4) - 4;
    }

    private static byte[] ensureArrayLength(byte[] bytes, int length) {
        if (bytes == null || length == 0) {
            return new byte[length];
        }
        if (bytes.length == length) {
            return bytes;
        }
        byte[] result = new byte[length];
        int max = result.length;
        if (bytes.length < max) {
            max = bytes.length;
        }
        System.arraycopy(bytes, 0, result, 0, max);
        return result;
    }

    private static boolean isNullBytes(byte[] bytes) {
        if (bytes == null) {
            return true;
        }
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 0) continue;
            return false;
        }
        return true;
    }
}

