/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

public interface ByteSource {
    public byte read(int var1);

    public void read(int var1, byte[] var2, int var3, int var4);

    public int length();

    default public int indexOf(int start, byte b) {
        int end = this.length();
        int last = end - 1;
        for (int i = start; i < end; ++i) {
            if (b == this.read(i)) {
                return i;
            }
            if (i != last) continue;
            end = this.length();
            last = end - 1;
        }
        return -1;
    }

    public static ByteSource of(byte[] bytes) {
        return ByteSource.of(bytes, 0, bytes.length);
    }

    public static ByteSource of(final byte[] bytes, final int start, final int size) {
        return new ByteSource(){

            @Override
            public byte read(int i) {
                return bytes[i];
            }

            @Override
            public void read(int position, byte[] buffer, int offset, int length) {
                System.arraycopy(bytes, start + position, buffer, offset, length);
            }

            @Override
            public int length() {
                return size;
            }
        };
    }
}

