/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.base;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.OffsetSupplier;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import java.io.IOException;

public class FixedDexContainer
extends FixedBlockContainer {
    public FixedDexContainer(int childesCount) {
        super(childesCount);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        Block[] childes = this.getChildes();
        if (childes == null) {
            return;
        }
        int length = childes.length;
        if (this.skipReading(this, reader)) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Block block = childes[i];
            if (block == null || this.skipReading(block, reader)) continue;
            block.readBytes(reader);
        }
    }

    protected void nonCheckRead(BlockReader reader) throws IOException {
        Block[] childes = this.getChildes();
        if (childes == null) {
            return;
        }
        for (Block block : childes) {
            if (block == null) continue;
            block.readBytes(reader);
        }
    }

    private boolean skipReading(Block block, BlockReader reader) {
        if (!(block instanceof OffsetSupplier)) {
            return false;
        }
        OffsetSupplier offsetSupplier = (OffsetSupplier)((Object)block);
        IntegerReference reference = offsetSupplier.getOffsetReference();
        if (reference != null) {
            int offset = reference.get();
            if (!this.isValidOffset(offset)) {
                return true;
            }
            reader.seek(offset);
        }
        return false;
    }

    protected boolean isValidOffset(int offset) {
        return offset > 0;
    }
}

