/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.common;

import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.EmptyIterator;
import java.lang.annotation.ElementType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Predicate;

public class AccessFlag
extends Modifier {
    public static final AccessFlag PUBLIC = new AccessFlag(1, "public", true, true, true);
    public static final AccessFlag PRIVATE = new AccessFlag(2, "private", true, true, true);
    public static final AccessFlag PROTECTED = new AccessFlag(4, "protected", true, true, true);
    public static final AccessFlag STATIC = new AccessFlag(8, "static", true, true, true);
    public static final AccessFlag FINAL = new AccessFlag(16, "final", true, true, true);
    public static final AccessFlag SYNCHRONIZED = new AccessFlag(32, "synchronized", false, true, false);
    public static final AccessFlag VOLATILE = new AccessFlag(64, "volatile", false, false, true);
    public static final AccessFlag BRIDGE = new AccessFlag(64, "bridge", false, true, false);
    public static final AccessFlag TRANSIENT = new AccessFlag(128, "transient", false, false, true);
    public static final AccessFlag VARARGS = new AccessFlag(128, "varargs", false, true, false);
    public static final AccessFlag NATIVE = new AccessFlag(256, "native", false, true, false);
    public static final AccessFlag INTERFACE = new AccessFlag(512, "interface", true, false, false);
    public static final AccessFlag ABSTRACT = new AccessFlag(1024, "abstract", true, true, false);
    public static final AccessFlag STRICTFP = new AccessFlag(2048, "strictfp", false, true, false);
    public static final AccessFlag SYNTHETIC = new AccessFlag(4096, "synthetic", true, true, true);
    public static final AccessFlag ANNOTATION = new AccessFlag(8192, "annotation", true, false, false);
    public static final AccessFlag ENUM = new AccessFlag(16384, "enum", true, false, true);
    public static final AccessFlag CONSTRUCTOR = new AccessFlag(65536, "constructor", false, true, false);
    public static final AccessFlag DECLARED_SYNCHRONIZED = new AccessFlag(131072, "declared-synchronized", false, true, false);
    private static final AccessFlag[] VALUES = new AccessFlag[]{PUBLIC, PRIVATE, PROTECTED, STATIC, FINAL, SYNCHRONIZED, VOLATILE, BRIDGE, TRANSIENT, VARARGS, NATIVE, INTERFACE, ABSTRACT, STRICTFP, SYNTHETIC, ANNOTATION, ENUM, CONSTRUCTOR, DECLARED_SYNCHRONIZED};
    private static final HashMap<String, AccessFlag> accessFlagsByName = new HashMap();
    private final boolean validForClass;
    private final boolean validForMethod;
    private final boolean validForField;

    private AccessFlag(int value, String name, boolean validForClass, boolean validForMethod, boolean validForField) {
        super(value, name);
        this.validForClass = validForClass;
        this.validForMethod = validForMethod;
        this.validForField = validForField;
    }

    @Override
    public boolean isSet(int accessFlags) {
        return (this.getValue() & accessFlags) != 0;
    }

    public boolean isSet(ElementType elementType, int accessFlags) {
        if (elementType == ElementType.TYPE) {
            return this.isSetForClass(accessFlags);
        }
        if (elementType == ElementType.FIELD) {
            return this.isSetForField(accessFlags);
        }
        if (elementType == ElementType.METHOD) {
            return this.isSetForMethod(accessFlags);
        }
        return false;
    }

    private boolean isSetForField(int value) {
        return this.validForField && (this.getValue() & value) != 0;
    }

    private boolean isSetForMethod(int value) {
        return this.validForMethod && (this.getValue() & value) != 0;
    }

    private boolean isSetForClass(int value) {
        return this.validForClass && (this.getValue() & value) != 0;
    }

    public static Iterator<AccessFlag> valuesOf(ElementType elementType, int value) {
        if (elementType == ElementType.TYPE) {
            return AccessFlag.valuesOfClass(value);
        }
        if (elementType == ElementType.FIELD) {
            return AccessFlag.valuesOfField(value);
        }
        if (elementType == ElementType.METHOD) {
            return AccessFlag.valuesOfMethod(value);
        }
        return EmptyIterator.of();
    }

    public static Iterator<AccessFlag> valuesOfClass(int value) {
        return AccessFlag.getValues(accessFlag -> accessFlag.isSetForClass(value));
    }

    public static Iterator<AccessFlag> valuesOfMethod(int value) {
        return AccessFlag.getValues(accessFlag -> accessFlag.isSetForMethod(value));
    }

    public static Iterator<AccessFlag> valuesOfField(int value) {
        return AccessFlag.getValues(accessFlag -> accessFlag.isSetForField(value));
    }

    public static AccessFlag valueOf(String name) {
        return accessFlagsByName.get(name);
    }

    public static Iterator<AccessFlag> getValues() {
        return AccessFlag.getValues(null);
    }

    public static Iterator<AccessFlag> getValues(Predicate<AccessFlag> filter) {
        return new ArrayIterator<AccessFlag>(VALUES, filter);
    }

    public static AccessFlag[] parse(SmaliReader reader) {
        AccessFlag flag;
        ArrayCollection<AccessFlag> accessFlags = null;
        while ((flag = AccessFlag.parseNext(reader)) != null) {
            if (accessFlags == null) {
                accessFlags = new ArrayCollection<AccessFlag>();
            }
            accessFlags.add(flag);
        }
        if (accessFlags == null) {
            return null;
        }
        int size = accessFlags.size();
        if (size == 0) {
            return null;
        }
        reader.skipWhitespaces();
        return accessFlags.toArray((T[])new AccessFlag[size]);
    }

    private static AccessFlag parseNext(SmaliReader reader) {
        reader.skipWhitespaces();
        int i = reader.indexOf(' ');
        if (i < 0) {
            return null;
        }
        int position = reader.position();
        AccessFlag accessFlag = AccessFlag.valueOf(reader.readString(i - reader.position()));
        if (accessFlag == null) {
            reader.position(position);
        }
        return accessFlag;
    }

    public static int combineAccessFlags(Iterator<? extends Modifier> iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            Modifier modifier = iterator.next();
            if (!(modifier instanceof AccessFlag)) continue;
            result |= modifier.getValue();
        }
        return result;
    }

    static {
        for (AccessFlag accessFlag : VALUES) {
            accessFlagsByName.put(accessFlag.getName(), accessFlag);
        }
    }
}

