/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.common;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.utils.ObjectsStore;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;

public class HiddenApiFlag
extends Modifier
implements SmaliFormat {
    public static final HiddenApiFlag WHITELIST = new HiddenApiFlag(0, "whitelist");
    public static final HiddenApiFlag GREYLIST = new HiddenApiFlag(1, "greylist");
    public static final HiddenApiFlag BLACKLIST = new HiddenApiFlag(2, "blacklist");
    public static final HiddenApiFlag GREYLIST_MAX_O = new HiddenApiFlag(3, "greylist-max-o");
    public static final HiddenApiFlag GREYLIST_MAX_P = new HiddenApiFlag(4, "greylist-max-p");
    public static final HiddenApiFlag GREYLIST_MAX_Q = new HiddenApiFlag(5, "greylist-max-q");
    public static final HiddenApiFlag GREYLIST_MAX_R = new HiddenApiFlag(6, "greylist-max-r");
    public static final HiddenApiFlag CORE_PLATFORM_API = new HiddenApiFlag(8, "core-platform-api", true);
    public static final int NO_RESTRICTION;
    public static final HiddenApiFlag TEST_API;
    private static final HiddenApiFlag[] RESTRICTION_VALUES;
    private static final HiddenApiFlag[] DOMAIN_VALUES;
    private static final HiddenApiFlag[] VALUES;
    private static final Map<String, HiddenApiFlag> NAME_MAP;
    private final boolean domainFlag;

    private HiddenApiFlag(int value, String name, boolean domainFlag) {
        super(value, name);
        this.domainFlag = domainFlag;
    }

    private HiddenApiFlag(int value, String name) {
        this(value, name, false);
    }

    @Override
    public boolean isSet(int value) {
        int v = this.getValue();
        if (this.domainFlag) {
            return (value & v) == v;
        }
        return (value & NO_RESTRICTION) == v;
    }

    public boolean isDomainFlag() {
        return this.domainFlag;
    }

    public static HiddenApiFlag valueOf(String name) {
        return NAME_MAP.get(name);
    }

    public static Iterator<HiddenApiFlag> valuesOf(int value) {
        if (value == NO_RESTRICTION) {
            return EmptyIterator.of();
        }
        if (value >= 0 && value < NO_RESTRICTION) {
            return SingleIterator.of(RESTRICTION_VALUES[value]);
        }
        return HiddenApiFlag.getValues(hiddenApiFlag -> hiddenApiFlag.isSet(value));
    }

    public static Iterator<HiddenApiFlag> getValues() {
        return HiddenApiFlag.getValues(null);
    }

    public static Iterator<HiddenApiFlag> getValues(Predicate<HiddenApiFlag> filter) {
        return new ArrayIterator<HiddenApiFlag>(VALUES, filter);
    }

    public static HiddenApiFlag restrictionOf(int value) {
        for (HiddenApiFlag flag : RESTRICTION_VALUES) {
            if (!flag.isSet(value)) continue;
            return flag;
        }
        return null;
    }

    public static HiddenApiFlag domainOf(int value) {
        for (HiddenApiFlag flag : DOMAIN_VALUES) {
            if (!flag.isSet(value)) continue;
            return flag;
        }
        return null;
    }

    public static HiddenApiFlag[] parse(SmaliReader reader) {
        HiddenApiFlag flag;
        Object container = null;
        while ((flag = HiddenApiFlag.parseNext(reader)) != null) {
            container = ObjectsStore.add(container, flag);
        }
        if (container == null) {
            return null;
        }
        int size = ObjectsStore.size(container);
        reader.skipWhitespaces();
        Object[] results = new HiddenApiFlag[size];
        ObjectsStore.collect(container, results);
        return results;
    }

    private static HiddenApiFlag parseNext(SmaliReader reader) {
        reader.skipWhitespaces();
        int i = reader.indexOf(' ');
        if (i < 0) {
            return null;
        }
        int position = reader.position();
        HiddenApiFlag hiddenApiFlag = HiddenApiFlag.valueOf(reader.readString(i - reader.position()));
        if (hiddenApiFlag == null) {
            reader.position(position);
        }
        return hiddenApiFlag;
    }

    public static int combineHiddenApiFlag(HiddenApiFlag[] flags) {
        int result = NO_RESTRICTION;
        if (flags != null) {
            for (HiddenApiFlag flag : flags) {
                int value = flag.getValue();
                if (result == NO_RESTRICTION) {
                    result = value;
                    continue;
                }
                result |= value;
            }
        }
        return result;
    }

    public static int combineHiddenApiFlag(Iterator<? extends Modifier> iterator) {
        int result = NO_RESTRICTION;
        while (iterator.hasNext()) {
            Modifier modifier = iterator.next();
            if (!(modifier instanceof AccessFlag)) continue;
            int value = modifier.getValue();
            if (result == NO_RESTRICTION) {
                result = value;
                continue;
            }
            result |= value;
        }
        return result;
    }

    static {
        TEST_API = new HiddenApiFlag(16, "test-api", true);
        NO_RESTRICTION = ObjectsUtil.of(7);
        RESTRICTION_VALUES = new HiddenApiFlag[]{WHITELIST, GREYLIST, BLACKLIST, GREYLIST_MAX_O, GREYLIST_MAX_P, GREYLIST_MAX_Q, GREYLIST_MAX_R};
        DOMAIN_VALUES = new HiddenApiFlag[]{CORE_PLATFORM_API, TEST_API};
        VALUES = new HiddenApiFlag[RESTRICTION_VALUES.length + DOMAIN_VALUES.length];
        HashMap<String, HiddenApiFlag> map = new HashMap<String, HiddenApiFlag>();
        int index = 0;
        for (HiddenApiFlag flag : RESTRICTION_VALUES) {
            HiddenApiFlag.VALUES[index++] = flag;
            map.put(flag.getName(), flag);
        }
        for (HiddenApiFlag flag : DOMAIN_VALUES) {
            HiddenApiFlag.VALUES[index++] = flag;
            map.put(flag.getName(), flag);
        }
        NAME_MAP = map;
    }
}

