/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.common;

import com.reandroid.arsc.base.Block;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.pool.DexSectionPool;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import java.util.Iterator;

public interface SectionTool {
    default public <T1 extends SectionItem> T1 createSectionItem(SectionType<T1> sectionType) {
        Section<T1> section = this.getOrCreateSection(sectionType);
        if (section != null) {
            return section.createItem();
        }
        return null;
    }

    default public <T1 extends SectionItem> T1 getSectionItem(SectionType<T1> sectionType, Key key) {
        Section<T1> section = this.getSection(sectionType);
        if (section != null) {
            return section.getSectionItem(key);
        }
        return null;
    }

    default public <T1 extends SectionItem> T1 getSectionItem(SectionType<T1> sectionType, int i) {
        Section<T1> section = this.getSection(sectionType);
        if (section != null) {
            return section.getSectionItem(i);
        }
        return null;
    }

    default public <T1 extends SectionItem> Section<T1> getSection(SectionType<T1> sectionType) {
        SectionList sectionList = this.getSectionList();
        if (sectionList != null) {
            return sectionList.getSection(sectionType);
        }
        return null;
    }

    default public boolean isReading() {
        SectionList sectionList = this.getSectionList();
        return sectionList == null || sectionList.isReading();
    }

    default public SectionList getSectionList() {
        return ((Block)((Object)this)).getParent(SectionList.class);
    }

    default public <T1 extends SectionItem> Section<T1> getOrCreateSection(SectionType<T1> sectionType) {
        SectionList sectionList = this.getSectionList();
        if (sectionList != null) {
            return sectionList.getOrCreateSection(sectionType);
        }
        return null;
    }

    default public <T1 extends SectionItem> T1 getOrCreateSectionItem(SectionType<T1> sectionType, Key key) {
        if (key == null) {
            return null;
        }
        Section<T1> section = this.getOrCreateSection(sectionType);
        if (section == null) {
            return null;
        }
        DexSectionPool<T1> pool = section.getPool();
        if (pool != null) {
            return pool.getOrCreate(key);
        }
        return null;
    }

    default public <T1 extends SectionItem> DexSectionPool<T1> getPool(SectionType<T1> sectionType) {
        Section<T1> section = this.getSection(sectionType);
        if (section != null) {
            return section.getPool();
        }
        return null;
    }

    public static <T extends SectionItem> int compareIdx(Iterator<T> iterator1, Iterator<T> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            int i = SectionTool.compareIdx((SectionItem)iterator1.next(), (SectionItem)iterator2.next());
            if (i == 0) continue;
            return i;
        }
        if (iterator1.hasNext()) {
            return 1;
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static <T extends SectionItem> int compareIdx(T item1, T item2) {
        int i2;
        if (item1 == item2) {
            return 0;
        }
        if (item1 == null) {
            return 1;
        }
        if (item2 == null) {
            return -1;
        }
        int i1 = item1.getIdx();
        if (i1 == (i2 = item2.getIdx())) {
            return 0;
        }
        if (i1 > i2) {
            return 1;
        }
        return -1;
    }

    public static <T extends Block> int compareIndex(T item1, T item2) {
        int i2;
        if (item1 == item2) {
            return 0;
        }
        if (item1 == null) {
            return 1;
        }
        if (item2 == null) {
            return -1;
        }
        int i1 = item1.getIndex();
        if (i1 == (i2 = item2.getIndex())) {
            return 0;
        }
        if (i1 > i2) {
            return 1;
        }
        return -1;
    }
}

