/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dalvik;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.AnnotationVisibility;
import com.reandroid.dex.dalvik.DalvikAnnotation;
import com.reandroid.dex.key.AnnotationElementKey;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.NullValueKey;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.AnnotatedProgram;
import java.util.Iterator;

public class DalvikInnerClass
extends DalvikAnnotation {
    private DalvikInnerClass(AnnotatedProgram annotatedProgram) {
        super(annotatedProgram, TypeKey.DALVIK_InnerClass);
    }

    public Iterator<AccessFlag> getAccessFlags() {
        return AccessFlag.valuesOfClass(this.getAccessFlagsValue());
    }

    public int getAccessFlagsValue() {
        PrimitiveKey key = (PrimitiveKey)this.readValue(Key.DALVIK_accessFlags);
        return (int)key.getValueAsLong();
    }

    public void setAccessFlags(int flags) {
        this.writeValue(Key.DALVIK_accessFlags, PrimitiveKey.of(flags));
    }

    public String getName() {
        Key key = this.readValue(Key.DALVIK_name);
        if (key instanceof StringKey) {
            return ((StringKey)key).getString();
        }
        return null;
    }

    public boolean hasName() {
        return this.readValue(Key.DALVIK_name) instanceof StringKey;
    }

    public void setName(String name) {
        Key key = name == null ? NullValueKey.INSTANCE : StringKey.create(name);
        this.writeValue(Key.DALVIK_name, key);
    }

    @Override
    public String toString() {
        return AccessFlag.toString(this.getAccessFlags()) + this.getName();
    }

    public static DalvikInnerClass of(AnnotatedProgram annotatedProgram) {
        if (annotatedProgram.hasAnnotation(TypeKey.DALVIK_InnerClass)) {
            return new DalvikInnerClass(annotatedProgram);
        }
        return null;
    }

    public static DalvikInnerClass getOrCreate(AnnotatedProgram annotatedProgram) {
        if (!annotatedProgram.hasAnnotation(TypeKey.DALVIK_InnerClass)) {
            annotatedProgram.addAnnotation(AnnotationItemKey.create(AnnotationVisibility.SYSTEM, TypeKey.DALVIK_InnerClass, AnnotationElementKey.create(Key.DALVIK_accessFlags, PrimitiveKey.of(0)), AnnotationElementKey.create(Key.DALVIK_name, NullValueKey.INSTANCE)));
        }
        return DalvikInnerClass.of(annotatedProgram);
    }
}

