/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IndirectInteger;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.data.AnnotationGroup;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.data.DirectoryEntry;
import com.reandroid.dex.data.DirectoryMap;
import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.DataKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.reference.DataItemIndirectReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class AnnotationsDirectory
extends DataItem
implements KeyReference {
    private final Header header = new Header();
    private final DirectoryMap<FieldDef, AnnotationSet> fieldsAnnotationMap;
    private final DirectoryMap<MethodDef, AnnotationSet> methodsAnnotationMap;
    private final DirectoryMap<MethodDef, AnnotationGroup> parametersAnnotationMap;
    private final DataKey<AnnotationsDirectory> mKey;
    private static final Creator<DirectoryEntry<FieldDef, AnnotationSet>> CREATOR_FIELDS = () -> new DirectoryEntry(SectionType.ANNOTATION_SET);
    private static final Creator<DirectoryEntry<MethodDef, AnnotationSet>> CREATOR_METHODS = () -> new DirectoryEntry(SectionType.ANNOTATION_SET);
    private static final Creator<DirectoryEntry<MethodDef, AnnotationGroup>> CREATOR_PARAMS = () -> new DirectoryEntry(SectionType.ANNOTATION_GROUP);

    public AnnotationsDirectory() {
        super(4);
        this.fieldsAnnotationMap = new DirectoryMap(this.header.fieldCount, CREATOR_FIELDS);
        this.methodsAnnotationMap = new DirectoryMap(this.header.methodCount, CREATOR_METHODS);
        this.parametersAnnotationMap = new DirectoryMap(this.header.parameterCount, CREATOR_PARAMS);
        this.mKey = new DataKey<AnnotationsDirectory>(this);
        this.addChildBlock(0, this.header);
        this.addChildBlock(1, this.fieldsAnnotationMap);
        this.addChildBlock(2, this.methodsAnnotationMap);
        this.addChildBlock(3, this.parametersAnnotationMap);
    }

    @Override
    public DataKey<AnnotationsDirectory> getKey() {
        return this.mKey;
    }

    @Override
    public void setKey(Key key) {
        DataKey dataKey = (DataKey)key;
        this.merge((AnnotationsDirectory)dataKey.getItem());
    }

    public SectionType<AnnotationsDirectory> getSectionType() {
        return SectionType.ANNOTATION_DIRECTORY;
    }

    public void setClassAnnotations(AnnotationSetKey setKey) {
        this.header.classAnnotation.setKey(setKey);
    }

    public AnnotationSet getOrCreateClassAnnotations() {
        return this.header.classAnnotation.getOrCreate();
    }

    public AnnotationSetKey getClassAnnotation() {
        AnnotationSetKey key = (AnnotationSetKey)this.header.classAnnotation.getKey();
        if (key == null) {
            key = AnnotationSetKey.empty();
        }
        return key;
    }

    public boolean hasClassAnnotation() {
        AnnotationSet annotationSet = (AnnotationSet)this.header.classAnnotation.getItem();
        if (annotationSet != null) {
            return !annotationSet.isEmpty();
        }
        return false;
    }

    public AnnotationSet getClassAnnotationBlock() {
        return (AnnotationSet)this.header.classAnnotation.getItem();
    }

    public void setClassAnnotations(AnnotationSet annotationSet) {
        this.header.classAnnotation.setItem(annotationSet);
    }

    @Override
    public boolean isBlank() {
        return this.isEmpty();
    }

    public boolean isEmpty() {
        return !this.hasClassAnnotation() && this.fieldsAnnotationMap.isEmpty() && this.methodsAnnotationMap.isEmpty() && this.parametersAnnotationMap.isEmpty();
    }

    public void sortFields() {
        this.fieldsAnnotationMap.sort();
    }

    public void sortMethods() {
        this.methodsAnnotationMap.sort();
        this.parametersAnnotationMap.sort();
    }

    public void link(Def<?> def) {
        if (def instanceof FieldDef) {
            this.linkField((FieldDef)def);
        } else if (def instanceof MethodDef) {
            this.linkMethod((MethodDef)def);
        }
    }

    public void linkField(FieldDef def) {
        this.fieldsAnnotationMap.link(def);
    }

    public void linkMethod(MethodDef def) {
        this.methodsAnnotationMap.link(def);
        this.parametersAnnotationMap.link(def);
    }

    public void remove(Def<?> def) {
        if (def instanceof FieldDef) {
            this.removeField((FieldDef)def);
        } else if (def instanceof MethodDef) {
            this.removeMethod((MethodDef)def);
        }
    }

    public void clear(Def<?> def) {
        if (def instanceof FieldDef) {
            this.removeField((FieldDef)def);
        } else if (def instanceof MethodDef) {
            MethodDef methodDef = (MethodDef)def;
            this.removeMethod(methodDef);
            this.removeParameter(methodDef);
        }
    }

    public void removeField(FieldDef def) {
        this.fieldsAnnotationMap.remove(def);
    }

    public void removeMethod(MethodDef def) {
        this.methodsAnnotationMap.remove(def);
    }

    public void removeParameter(MethodDef def) {
        this.parametersAnnotationMap.remove(def);
    }

    public void addAnnotation(Def<?> def, AnnotationSetKey key) {
        this.addAnnotation(def, this.getOrCreateSectionItem(SectionType.ANNOTATION_SET, key));
    }

    public void addAnnotation(Def<?> def, AnnotationSet annotationSet) {
        if (def instanceof FieldDef) {
            this.addFieldAnnotation((FieldDef)def, annotationSet);
        } else if (def instanceof MethodDef) {
            this.addMethodAnnotation((MethodDef)def, annotationSet);
        }
    }

    public void addFieldAnnotation(FieldDef fieldDef, AnnotationSet annotationSet) {
        this.fieldsAnnotationMap.add(fieldDef, this.ensureSameContext(annotationSet));
    }

    public void addMethodAnnotation(MethodDef methodDef, AnnotationSet annotationSet) {
        this.methodsAnnotationMap.add(methodDef, this.ensureSameContext(annotationSet));
    }

    private AnnotationSet ensureSameContext(AnnotationSet annotationSet) {
        if (this.isSameContext(annotationSet)) {
            return annotationSet;
        }
        AnnotationSet mySet = this.getOrCreateSection(SectionType.ANNOTATION_SET).createItem();
        mySet.merge(annotationSet);
        return mySet;
    }

    public Iterator<AnnotationSet> getAnnotations(Def<?> def) {
        if (def.getClass() == FieldDef.class) {
            return this.getFieldsAnnotation((FieldDef)def);
        }
        if (def.getClass() == MethodDef.class) {
            return this.getMethodAnnotation((MethodDef)def);
        }
        throw new IllegalArgumentException("Unknown class type: " + def.getClass());
    }

    public Iterator<AnnotationSet> getFieldsAnnotation(FieldDef fieldDef) {
        return this.fieldsAnnotationMap.getValues(fieldDef);
    }

    public Iterator<AnnotationSet> getMethodAnnotation(MethodDef methodDef) {
        return this.methodsAnnotationMap.getValues(methodDef);
    }

    public Iterator<AnnotationGroup> getParameterAnnotation(MethodDef methodDef) {
        return this.parametersAnnotationMap.getValues(methodDef);
    }

    public Iterator<AnnotationGroup> getParameterAnnotation(int methodIndex) {
        return this.parametersAnnotationMap.getValues((MethodDef)methodIndex);
    }

    public Iterator<AnnotationSet> getParameterAnnotation(MethodDef methodDef, int parameterIndex) {
        return ComputeIterator.of(this.getParameterAnnotation(methodDef), annotationGroup -> (AnnotationSet)annotationGroup.getItem(parameterIndex));
    }

    public Iterator<AnnotationSet> getParameterAnnotation(int methodIndex, int parameterIndex) {
        return ComputeIterator.of(this.getParameterAnnotation(methodIndex), annotationGroup -> (AnnotationSet)annotationGroup.getItem(parameterIndex));
    }

    public void setParameterAnnotation(MethodDef methodDef, int parameterIndex, AnnotationSetKey key) {
        AnnotationGroup annotationGroup = this.getEmptyParameterAnnotationGroup(methodDef, parameterIndex);
        annotationGroup.setItemKeyAt(parameterIndex, key);
    }

    public void removeParameterAnnotation(MethodDef methodDef, int parameterIndex) {
        Iterator<AnnotationGroup> iterator = this.parametersAnnotationMap.getValues(methodDef);
        while (iterator.hasNext()) {
            AnnotationGroup group = iterator.next();
            if (group == null) continue;
            group.clearAt(parameterIndex);
        }
    }

    private AnnotationGroup getEmptyParameterAnnotationGroup(MethodDef methodDef, int parameterIndex) {
        Iterator<AnnotationGroup> iterator = this.parametersAnnotationMap.getValues(methodDef);
        while (iterator.hasNext()) {
            AnnotationGroup group = iterator.next();
            if (group.getItem(parameterIndex) != null) continue;
            return group;
        }
        AnnotationGroup annotationGroup = this.getOrCreateSection(SectionType.ANNOTATION_GROUP).createItem();
        this.parametersAnnotationMap.add(methodDef, annotationGroup);
        return annotationGroup;
    }

    public void replaceKeys(Key search, Key replace) {
        AnnotationSet set = this.getClassAnnotationBlock();
        if (set != null) {
            set.replaceKeys(search, replace);
        }
        Iterator<AnnotationSet> iterator = this.fieldsAnnotationMap.getValues();
        while (iterator.hasNext()) {
            iterator.next().replaceKeys(search, replace);
        }
        iterator = this.methodsAnnotationMap.getValues();
        while (iterator.hasNext()) {
            iterator.next().replaceKeys(search, replace);
        }
        Iterator<AnnotationGroup> groupIterator = this.parametersAnnotationMap.getValues();
        while (groupIterator.hasNext()) {
            groupIterator.next().replaceKeys(search, replace);
        }
    }

    @Override
    public void editInternal(Block user) {
        this.header.editInternal(user);
        this.fieldsAnnotationMap.editInternal();
        this.parametersAnnotationMap.editInternal();
    }

    @Override
    public Iterator<IdItem> usedIds() {
        AnnotationSet classAnnotation = this.getClassAnnotationBlock();
        Iterator<Object> iterator1 = classAnnotation == null ? EmptyIterator.of() : classAnnotation.usedIds();
        IterableIterator<AnnotationSet, IdItem> iterator2 = new IterableIterator<AnnotationSet, IdItem>(this.fieldsAnnotationMap.getValues()){

            @Override
            public Iterator<IdItem> iterator(AnnotationSet element) {
                return element.usedIds();
            }
        };
        IterableIterator<AnnotationSet, IdItem> iterator3 = new IterableIterator<AnnotationSet, IdItem>(this.methodsAnnotationMap.getValues()){

            @Override
            public Iterator<IdItem> iterator(AnnotationSet element) {
                return element.usedIds();
            }
        };
        IterableIterator<AnnotationGroup, IdItem> iterator4 = new IterableIterator<AnnotationGroup, IdItem>(this.parametersAnnotationMap.getValues()){

            @Override
            public Iterator<IdItem> iterator(AnnotationGroup element) {
                return element.usedIds();
            }
        };
        return CombiningIterator.four(iterator1, iterator2, iterator3, iterator4);
    }

    @Override
    protected void onPreRefresh() {
        this.header.refresh();
        super.onPreRefresh();
    }

    public void merge(AnnotationsDirectory directory) {
        if (directory == this) {
            return;
        }
        this.header.merge(directory.header);
        this.fieldsAnnotationMap.merge(directory.fieldsAnnotationMap);
        this.methodsAnnotationMap.merge(directory.methodsAnnotationMap);
        this.parametersAnnotationMap.merge(directory.parametersAnnotationMap);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationsDirectory directory = (AnnotationsDirectory)obj;
        return Objects.equals(this.header, directory.header) && Objects.equals(this.fieldsAnnotationMap, directory.fieldsAnnotationMap) && Objects.equals(this.methodsAnnotationMap, directory.methodsAnnotationMap) && Objects.equals(this.parametersAnnotationMap, directory.parametersAnnotationMap);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.header.hashCode();
        hash = hash * 31 + this.fieldsAnnotationMap.hashCode();
        hash = hash * 31 + this.methodsAnnotationMap.hashCode();
        hash = hash * 31 + this.parametersAnnotationMap.hashCode();
        return hash;
    }

    public String toString() {
        return this.header + ", fields=" + this.fieldsAnnotationMap + ", methods=" + this.methodsAnnotationMap + ", parameters=" + this.parametersAnnotationMap;
    }

    static class Header
    extends SectionItem
    implements BlockRefresh {
        final DataItemIndirectReference<AnnotationSet> classAnnotation = new DataItemIndirectReference<AnnotationSet>(SectionType.ANNOTATION_SET, this, 0, UsageMarker.USAGE_ANNOTATION);
        final IndirectInteger fieldCount = new IndirectInteger(this, 4);
        final IndirectInteger methodCount = new IndirectInteger(this, 8);
        final IndirectInteger parameterCount = new IndirectInteger(this, 12);

        public Header() {
            super(16);
        }

        public boolean isEmpty() {
            return this.classAnnotation.get() == 0 && this.fieldCount.get() == 0 && this.methodCount.get() == 0 && this.parameterCount.get() == 0;
        }

        @Override
        public void onReadBytes(BlockReader reader) throws IOException {
            super.onReadBytes(reader);
            this.cacheItems();
        }

        private void cacheItems() {
            this.classAnnotation.pullItem();
            this.classAnnotation.addUniqueUser(this);
        }

        @Override
        public void refresh() {
            this.classAnnotation.refresh();
            this.classAnnotation.addUniqueUser(this);
        }

        public void merge(Header header) {
            this.classAnnotation.setKey(header.classAnnotation.getKey());
        }

        @Override
        public void editInternal(Block user) {
            this.classAnnotation.getUniqueItem(this);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Header header = (Header)obj;
            return Objects.equals(this.classAnnotation.getItem(), header.classAnnotation.getItem());
        }

        public int hashCode() {
            int hash = 1;
            SectionItem obj = this.classAnnotation.getItem();
            hash *= 31;
            if (obj != null) {
                hash += obj.hashCode();
            }
            return hash;
        }

        public String toString() {
            return "class=" + this.classAnnotation + ", fields=" + this.fieldCount + ", methods=" + this.methodCount + ", parameters=" + this.parameterCount;
        }
    }
}

