/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.common.EditableItem;
import com.reandroid.dex.common.HiddenApiFlag;
import com.reandroid.dex.common.IdDefinition;
import com.reandroid.dex.common.IdUsageIterator;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.data.AnnotationSet;
import com.reandroid.dex.data.AnnotationsDirectory;
import com.reandroid.dex.data.ClassData;
import com.reandroid.dex.data.DefArray;
import com.reandroid.dex.data.DefIndex;
import com.reandroid.dex.data.FixedDexContainerWithTool;
import com.reandroid.dex.data.HiddenApiFlagValue;
import com.reandroid.dex.data.HiddenApiRestrictions;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.AnnotationItemKey;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.ProgramKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.pool.DexSectionPool;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionList;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliDef;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.ExpandIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public abstract class Def<T extends IdItem>
extends FixedDexContainerWithTool
implements IdDefinition<T>,
EditableItem,
Comparable<Def<T>>,
SmaliRegion,
DefIndex,
IdUsageIterator {
    private final SectionType<T> sectionType;
    private final Ule128Item relativeId;
    private final Ule128Item accessFlags;
    private T mDefId;
    private int mCachedIndex;
    private boolean mCachedIndexUpdated;
    private HiddenApiFlagValue hiddenApiFlagValue;

    public Def(int childesCount, SectionType<T> sectionType) {
        super(childesCount + 2);
        this.sectionType = sectionType;
        this.relativeId = new Ule128Item(true);
        this.accessFlags = new Ule128Item();
        this.addChild(0, this.relativeId);
        this.addChild(1, this.accessFlags);
    }

    @Override
    public AnnotationSetKey getAnnotation() {
        return AnnotationSetKey.create(ComputeIterator.of(this.getAnnotationItemBlocks(), AnnotationItem::getKey));
    }

    @Override
    public void setAnnotation(AnnotationSetKey annotationSet) {
        if (!ObjectsUtil.equals(this.getAnnotation(), annotationSet)) {
            this.clearAnnotations();
            this.writeAnnotation(annotationSet);
        }
    }

    @Override
    public void clearAnnotations() {
        this.writeAnnotation(AnnotationSetKey.empty());
    }

    private boolean hasAnnotationSetBlocks() {
        return this.getAnnotationItemBlocks().hasNext();
    }

    private Iterator<AnnotationItem> getAnnotationItemBlocks() {
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory != null) {
            return ExpandIterator.of(directory.getAnnotations(this));
        }
        return EmptyIterator.of();
    }

    private void writeAnnotation(AnnotationSetKey key) {
        if (key == null || key.isEmpty()) {
            if (this.hasAnnotationSetBlocks()) {
                this.getOrCreateUniqueAnnotationsDirectory().remove(this);
            }
        } else {
            this.getOrCreateUniqueAnnotationsDirectory().addAnnotation(this, key);
        }
    }

    @Override
    public Iterator<? extends Modifier> getModifiers() {
        return CombiningIterator.two(this.getAccessFlags(), this.getHiddenApiFlags());
    }

    public Iterator<HiddenApiFlag> getHiddenApiFlags() {
        HiddenApiFlagValue flagValue = this.getHiddenApiFlagValue();
        if (flagValue != null) {
            return flagValue.iterator();
        }
        return EmptyIterator.of();
    }

    public void addHiddenApiFlags(Iterator<HiddenApiFlag> iterator) {
        while (iterator.hasNext()) {
            this.addHiddenApiFlag(iterator.next());
        }
    }

    public void addHiddenApiFlag(HiddenApiFlag flag) {
        if (flag != null) {
            HiddenApiFlagValue flagValue = this.getOrCreateHiddenApiFlagValue();
            flagValue.add(flag);
        }
    }

    public void removeHiddenApiFlag(HiddenApiFlag flag) {
        HiddenApiFlagValue flagValue;
        if (flag != null && (flagValue = this.getHiddenApiFlagValue()) != null) {
            flagValue.remove(flag);
        }
    }

    public void removeHiddenApiFlags() {
        HiddenApiFlagValue flagValue = this.getHiddenApiFlagValue();
        if (flagValue != null) {
            flagValue.clear();
        }
    }

    public HiddenApiFlagValue getOrCreateHiddenApiFlagValue() {
        HiddenApiFlagValue flagValue = this.getHiddenApiFlagValue();
        if (flagValue == null) {
            Section<HiddenApiRestrictions> section = this.getOrCreateSection(SectionType.HIDDEN_API);
            HiddenApiRestrictions restrictions = (HiddenApiRestrictions)section.get(0);
            if (restrictions == null) {
                restrictions = section.createItem();
            }
            flagValue = restrictions.getFlagValue(this.getKey());
        }
        return flagValue;
    }

    public HiddenApiFlagValue getHiddenApiFlagValue() {
        return this.hiddenApiFlagValue;
    }

    public void linkHiddenApiFlagValueInternal(HiddenApiFlagValue hiddenApiFlagValue) {
        this.hiddenApiFlagValue = hiddenApiFlagValue;
    }

    public void removeSelf() {
        DefArray<Def<Def>> array = this.getParentArray();
        if (array != null) {
            array.remove(this);
        }
    }

    @Override
    public boolean isRemoved() {
        if (this.getParent() == null) {
            return true;
        }
        T id = this.getId();
        return id == null || ((SectionItem)id).isRemoved();
    }

    void onRemove() {
        HiddenApiFlagValue flagValue = this.getHiddenApiFlagValue();
        if (flagValue != null) {
            this.linkHiddenApiFlagValueInternal(null);
            flagValue.removeSelf();
        }
        this.mCachedIndexUpdated = true;
        this.mDefId = null;
        this.relativeId.set(0);
    }

    @Override
    public abstract ProgramKey getKey();

    public void setKey(Key key) {
        this.setItem(key);
    }

    public Iterator<AnnotationItemKey> getAnnotationKeys() {
        Iterator<AnnotationSetKey> iterator = this.getAnnotationSetKeys();
        if (!iterator.hasNext()) {
            return EmptyIterator.of();
        }
        return new IterableIterator<AnnotationSetKey, AnnotationItemKey>(iterator){

            @Override
            public Iterator<AnnotationItemKey> iterator(AnnotationSetKey element) {
                return element.iterator();
            }
        };
    }

    public Iterator<AnnotationSetKey> getAnnotationSetKeys() {
        return ComputeIterator.of(this.getAnnotationSets(true), AnnotationSet::getKey);
    }

    public Iterator<AnnotationSet> getAnnotationSets(boolean skipEmpty) {
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory == null) {
            return EmptyIterator.of();
        }
        Iterator<AnnotationSet> iterator = directory.getAnnotations(this);
        if (!skipEmpty || !iterator.hasNext()) {
            return iterator;
        }
        return FilterIterator.of(iterator, annotationSet -> !annotationSet.isEmpty());
    }

    public AnnotationsDirectory getAnnotationsDirectory() {
        ClassId classId = this.getClassId();
        if (classId != null) {
            return classId.getAnnotationsDirectory();
        }
        return null;
    }

    public AnnotationsDirectory getOrCreateUniqueAnnotationsDirectory() {
        ClassId classId = this.getClassId();
        if (classId != null) {
            return classId.getOrCreateUniqueAnnotationsDirectory();
        }
        return null;
    }

    public ClassId getClassId() {
        ClassId classId;
        DefArray<Def<T>> array = this.getParentArray();
        if (array != null && (classId = array.getClassId()) != null) {
            return classId;
        }
        SectionList sectionList = this.getSectionList();
        if (sectionList == null || sectionList.isReading()) {
            return null;
        }
        TypeKey defining = this.getDefining();
        if (defining == null) {
            return null;
        }
        DexSectionPool<ClassId> pool = this.getPool(SectionType.CLASS_ID);
        if (pool == null) {
            return null;
        }
        ClassId classId2 = (ClassId)pool.get(defining);
        if (classId2 == null) {
            return null;
        }
        ClassData classData = this.getClassData();
        if (classData == null) {
            return null;
        }
        classData.setClassId(classId2);
        return classId2;
    }

    public TypeKey getDefining() {
        ProgramKey key = this.getKey();
        if (key != null) {
            return key.getDeclaring();
        }
        return null;
    }

    public int getRelativeIdValue() {
        return this.relativeId.get();
    }

    @Override
    public int getAccessFlagsValue() {
        return this.accessFlags.get();
    }

    @Override
    public void setAccessFlagsValue(int value) {
        this.accessFlags.set(value);
    }

    @Override
    public T getId() {
        return this.mDefId;
    }

    void setItem(Key key) {
        Object item = this.getId();
        if (item != null && key.equals(((IdItem)item).getKey())) {
            return;
        }
        item = (IdItem)this.getOrCreateSection(this.sectionType).getOrCreate(key);
        this.setItem(item);
    }

    void setItem(T item) {
        this.mDefId = item;
        this.updateIndex();
    }

    @Override
    public int getDefinitionIndex() {
        if (!this.mCachedIndexUpdated) {
            this.mCachedIndexUpdated = true;
            this.mCachedIndex = this.calculateDefinitionIndex();
        }
        return this.mCachedIndex;
    }

    private int calculateDefinitionIndex() {
        Def previous;
        DefArray<Def<T>> parentArray = this.getParentArray();
        if (parentArray != null && (previous = (Def)parentArray.get(this.getIndex() - 1)) != null) {
            return this.getRelativeIdValue() + previous.getDefinitionIndex();
        }
        return this.relativeId.get();
    }

    private int getPreviousIdIndex() {
        Def previous;
        DefArray<Def<T>> parentArray = this.getParentArray();
        if (parentArray != null && (previous = (Def)parentArray.get(this.getIndex() - 1)) != null) {
            return previous.getDefinitionIndex();
        }
        return 0;
    }

    private ClassData getClassData() {
        DefArray<Def<T>> array = this.getParentArray();
        if (array != null) {
            return array.getClassData();
        }
        return null;
    }

    private DefArray<Def<T>> getParentArray() {
        return (DefArray)this.getParent();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.cacheItem();
    }

    private void cacheItem() {
        this.mDefId = (IdItem)this.getSectionItem(this.sectionType, this.getDefinitionIndex());
        if (this.mDefId != null) {
            ((SectionItem)this.mDefId).addUsageType(IdItem.USAGE_DEFINITION);
        }
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.updateIndex();
        this.updateHiddenApiFlag();
    }

    private void updateIndex() {
        this.resetIndex();
        Object item = this.mDefId;
        item = (IdItem)((SectionItem)item).getReplace();
        this.mDefId = item;
        int index = this.getPreviousIdIndex();
        index = ((Block)item).getIndex() - index;
        this.relativeId.set(index);
        ((SectionItem)item).addUsageType(IdItem.USAGE_DEFINITION);
    }

    void resetIndex() {
        this.mCachedIndexUpdated = false;
    }

    private void updateHiddenApiFlag() {
        HiddenApiFlagValue hiddenApiFlagValue = this.hiddenApiFlagValue;
        if (hiddenApiFlagValue != null && hiddenApiFlagValue.isRemoved()) {
            this.hiddenApiFlagValue = null;
        }
    }

    public void replaceKeys(Key search, Key replace) {
        Key key2;
        ProgramKey key = this.getKey();
        if (key != (key2 = key.replaceKey(search, replace))) {
            this.setItem(key2);
        }
    }

    @Override
    public void editInternal(Block user) {
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return SingleIterator.of(this.getId());
    }

    public void merge(Def<?> def) {
        this.setItem(def.getKey());
        this.setAccessFlagsValue(def.getAccessFlagsValue());
        HiddenApiFlagValue flagValue = def.getHiddenApiFlagValue();
        if (flagValue != null) {
            this.addHiddenApiFlag(flagValue.getRestriction());
            this.addHiddenApiFlag(flagValue.getDomain());
        }
    }

    public abstract void fromSmali(Smali var1);

    public abstract SmaliDef toSmali();

    @Override
    public int compareTo(Def<T> other) {
        if (other == null) {
            return -1;
        }
        return SectionTool.compareIdx(this.getId(), other.getId());
    }
}

