/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.data.HiddenApiData;
import com.reandroid.dex.data.HiddenApiDataList;
import com.reandroid.dex.data.HiddenApiFlagValue;
import com.reandroid.dex.data.HiddenApiIndex;
import com.reandroid.dex.data.HiddenApiIndexList;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import java.io.IOException;

public class HiddenApiRestrictions
extends DataItem {
    private final IntegerItem sizeReference = new IntegerItem();
    private final HiddenApiIndexList hiddenApiIndexList = new HiddenApiIndexList();
    private final HiddenApiDataList hiddenApiDataList = new HiddenApiDataList();

    public HiddenApiRestrictions() {
        super(3);
        this.addChildBlock(0, this.sizeReference);
        this.addChildBlock(1, this.hiddenApiIndexList);
        this.addChildBlock(2, this.hiddenApiDataList);
    }

    public HiddenApiFlagValue getFlagValue(Key key) {
        return this.getHiddenApiIndexList().getFlagValue(key);
    }

    public HiddenApiIndexList getHiddenApiIndexList() {
        return this.hiddenApiIndexList;
    }

    public HiddenApiDataList getHiddenApiDataList() {
        return this.hiddenApiDataList;
    }

    HiddenApiIndex createNew(ClassId classId) {
        return this.getHiddenApiIndexList().createNext(classId, this.getHiddenApiDataList().createNext());
    }

    public boolean isAllNoRestrictions() {
        return this.getHiddenApiIndexList().isAllNoRestrictions();
    }

    public void removeIfAllNoRestrictions() {
        Section<HiddenApiRestrictions> section = this.getSection(SectionType.HIDDEN_API);
        if (section == null) {
            return;
        }
        if (!this.isAllNoRestrictions()) {
            return;
        }
        this.getHiddenApiIndexList().clearChildes();
        HiddenApiDataList hiddenApiDataList = this.getHiddenApiDataList();
        hiddenApiDataList.setItem(null);
        hiddenApiDataList.setParent(null);
        this.removeSelf();
        section.removeSelf();
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.updateSizeFast();
        this.updateUsageType();
    }

    private void updateUsageType() {
        if (this.getIndex() != 0) {
            return;
        }
        if (this.getUsageType() != UsageMarker.USAGE_NONE) {
            return;
        }
        Section<ClassId> section = this.getSection(SectionType.CLASS_ID);
        if (section != null && !section.isEmpty()) {
            this.addUsageType(UsageMarker.USAGE_DEFINITION);
        }
    }

    private void updateSizeFast() {
        int size = 0;
        HiddenApiData last = this.hiddenApiDataList.getLast();
        if (last != null && (size = last.getOffset()) != 0) {
            size += last.countBytes();
        }
        if (size == 0 || size != this.sizeReference.get()) {
            size = this.countBytes();
        }
        this.sizeReference.set(size);
    }

    int getHiddenApiDataListOffset() {
        return this.sizeReference.countBytes() + this.hiddenApiIndexList.countBytes();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.sizeReference.readBytes(reader);
        reader.offset(-this.sizeReference.countBytes());
        int size = this.sizeReference.get();
        BlockReader restrictionsReader = reader.create(size);
        restrictionsReader.offset(this.sizeReference.countBytes());
        this.hiddenApiIndexList.onReadBytes(restrictionsReader);
        this.hiddenApiDataList.onReadBytes(restrictionsReader);
        restrictionsReader.close();
        reader.seek(size);
    }

    public SectionType<HiddenApiRestrictions> getSectionType() {
        return SectionType.HIDDEN_API;
    }

    public String toString() {
        return "index = " + this.hiddenApiIndexList + ", data = " + this.hiddenApiDataList;
    }
}

