/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.dex.dalvik.DalvikSignature;
import com.reandroid.dex.data.AnnotationItem;
import com.reandroid.dex.data.AnnotationsDirectory;
import com.reandroid.dex.data.DebugInfo;
import com.reandroid.dex.data.DefIndex;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.debug.DebugParameter;
import com.reandroid.dex.id.ProtoId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.DalvikSignatureKey;
import com.reandroid.dex.key.ParameterisedTypeKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.program.MethodParameterProgram;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliMethodParameter;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.ExpandIterator;
import java.io.IOException;
import java.util.Iterator;

public class MethodParameter
implements DefIndex,
MethodParameterProgram,
SmaliRegion {
    private final MethodDef methodDef;
    private final int index;

    public MethodParameter(MethodDef methodDef, int index) {
        this.methodDef = methodDef;
        this.index = index;
    }

    @Override
    public AnnotationSetKey getAnnotation() {
        return AnnotationSetKey.create(ComputeIterator.of(this.getAnnotationItemBlocks(), AnnotationItem::getKey));
    }

    @Override
    public void setAnnotation(AnnotationSetKey annotationSet) {
        this.clearAnnotations();
        this.writeAnnotation(annotationSet);
    }

    @Override
    public void clearAnnotations() {
        this.writeAnnotation(AnnotationSetKey.empty());
    }

    public void onRemoved() {
        this.clearAnnotations();
        this.clearDebugParameter();
    }

    private boolean hasAnnotationSetBlocks() {
        MethodDef methodDef = this.getMethodDef();
        AnnotationsDirectory directory = methodDef.getAnnotationsDirectory();
        if (directory != null) {
            return directory.getParameterAnnotation(methodDef, this.getDefinitionIndex()).hasNext();
        }
        return false;
    }

    private Iterator<AnnotationItem> getAnnotationItemBlocks() {
        MethodDef methodDef = this.getMethodDef();
        AnnotationsDirectory directory = methodDef.getAnnotationsDirectory();
        if (directory != null) {
            return ExpandIterator.of(directory.getParameterAnnotation(methodDef, this.getDefinitionIndex()));
        }
        return EmptyIterator.of();
    }

    private void writeAnnotation(AnnotationSetKey key) {
        MethodDef methodDef = this.getMethodDef();
        int index = this.getDefinitionIndex();
        if (key == null || key.isEmpty()) {
            if (this.hasAnnotationSetBlocks()) {
                AnnotationsDirectory directory = methodDef.getOrCreateUniqueAnnotationsDirectory();
                directory.removeParameterAnnotation(methodDef, index);
            }
        } else {
            AnnotationsDirectory directory = methodDef.getOrCreateUniqueAnnotationsDirectory();
            directory.removeParameterAnnotation(methodDef, index);
            directory.setParameterAnnotation(methodDef, index, key);
        }
    }

    public TypeKey getType() {
        TypeId typeId = this.getTypeId();
        if (typeId != null) {
            return typeId.getKey();
        }
        return null;
    }

    public TypeId getTypeId() {
        ProtoId protoId = this.getMethodDef().getProtoId();
        if (protoId != null) {
            return protoId.getParameter(this.getDefinitionIndex());
        }
        return null;
    }

    public MethodDef getMethodDef() {
        return this.methodDef;
    }

    @Override
    public int getDefinitionIndex() {
        return this.index;
    }

    public int getRegister() {
        MethodDef methodDef = this.getMethodDef();
        int reg = methodDef.isStatic() ? 0 : 1;
        return reg += methodDef.getKey().getRegister(this.getDefinitionIndex());
    }

    public void clearDebugParameter() {
        DebugInfo debugInfo = this.getMethodDef().getDebugInfo();
        if (debugInfo != null) {
            debugInfo.removeDebugParameter(this.getDefinitionIndex());
        }
    }

    @Override
    public String getDebugName() {
        DebugParameter debugParameter = this.getDebugParameter();
        if (debugParameter != null) {
            return debugParameter.getName();
        }
        return null;
    }

    @Override
    public void setDebugName(String name) {
        MethodDef methodDef;
        DebugInfo debugInfo;
        if (StringsUtil.isEmpty(name)) {
            name = null;
        }
        if ((debugInfo = (methodDef = this.getMethodDef()).getDebugInfo()) == null) {
            if (name == null) {
                return;
            }
            debugInfo = methodDef.getOrCreateDebugInfo();
        }
        if (name == null) {
            debugInfo.removeDebugParameter(this.getDefinitionIndex());
            return;
        }
        DebugParameter parameter = debugInfo.getOrCreateDebugParameter(this.getDefinitionIndex());
        parameter.setName(name);
    }

    public DebugParameter getDebugParameter() {
        DebugInfo debugInfo = this.getMethodDef().getDebugInfo();
        if (debugInfo != null) {
            return debugInfo.getDebugParameter(this.getDefinitionIndex());
        }
        return null;
    }

    @Override
    public TypeKey getKey() {
        TypeId typeId = this.getTypeId();
        if (typeId != null) {
            return typeId.getKey();
        }
        return null;
    }

    public void fromSmali(SmaliMethodParameter smaliMethodParameter) {
        if (smaliMethodParameter.hasAnnotations()) {
            this.setAnnotation(smaliMethodParameter.getSmaliAnnotationSet().getKey());
        }
        this.setDebugName(smaliMethodParameter.getDebugName());
    }

    public ParameterisedTypeKey getParameterisedTypeKey() {
        ParameterisedTypeKey typeKey;
        DalvikSignatureKey signatureKey;
        DalvikSignature dalvikSignature = DalvikSignature.of(this.getMethodDef());
        if (dalvikSignature != null && (signatureKey = dalvikSignature.getSignature()) != null && (typeKey = signatureKey.getProtoParameter(this.getDefinitionIndex())) != null && typeKey.isParametrisedType()) {
            return typeKey;
        }
        return null;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        ParameterisedTypeKey typeKey;
        boolean has_annotation;
        DebugParameter debugParameter = this.getDebugParameter();
        boolean has_debug = debugParameter != null && debugParameter.getNameId() != null;
        AnnotationSetKey annotation = this.getAnnotation();
        boolean bl = has_annotation = !annotation.isEmpty();
        if (!has_debug && !has_annotation) {
            return;
        }
        writer.newLine();
        this.getSmaliDirective().append(writer);
        writer.append('p');
        writer.appendInteger(this.getRegister());
        if (has_debug) {
            debugParameter.append(writer);
        }
        if ((typeKey = this.getParameterisedTypeKey()) != null) {
            writer.appendComment(typeKey.getComment());
        } else {
            writer.appendComment(this.getType().getTypeName());
        }
        if (!has_annotation) {
            return;
        }
        writer.indentPlus();
        writer.appendAllWithDoubleNewLine(annotation.iterator());
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    public int hashCode() {
        return this.methodDef.hashCode() * 31 + this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodParameter parameter = (MethodParameter)obj;
        return this.index == parameter.index && this.getMethodDef() == parameter.getMethodDef();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.PARAM;
    }

    public String toString() {
        return SmaliWriter.toStringSafe(this);
    }
}

