/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.dex.base.DexPositionAlign;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.ArrayKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyList;
import com.reandroid.dex.reference.ShortIdReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.NumbersUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ComputeIterator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;

public class ShortIdList<T extends IdItem>
extends DataItem
implements Comparable<ShortIdList<T>> {
    private final CountedBlockList<ShortIdReference<T>> referenceList;
    private final DexPositionAlign positionAlign;

    public ShortIdList(SectionType<T> sectionType, int usageType) {
        super(3);
        IntegerItem countReference = new IntegerItem();
        this.referenceList = new CountedBlockList<T>(new ReferenceCreator<T>(sectionType, usageType), countReference);
        this.positionAlign = new DexPositionAlign();
        this.addChildBlock(0, countReference);
        this.addChildBlock(1, this.referenceList);
        this.addChildBlock(2, this.positionAlign);
    }

    @Override
    public KeyList<?> getKey() {
        Key[] elements = new Key[this.size()];
        this.getItemKeys(elements);
        return ArrayKey.create(elements);
    }

    public void setKey(Key key) {
        KeyList keyList = (KeyList)key;
        Key old = this.getKey();
        if (KeyList.equalsIgnoreEmpty(keyList, (KeyList)ObjectsUtil.cast(old))) {
            return;
        }
        int size = keyList.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            this.getReference(i).setKey((Key)keyList.get(i));
        }
        this.keyChanged(old);
    }

    public int size() {
        return this.referenceList.size();
    }

    public void setSize(int size) {
        this.referenceList.setSize(size);
    }

    public void clear() {
        this.setSize(0);
    }

    private void ensureSize(int size) {
        this.referenceList.ensureSize(size);
    }

    private ShortIdReference<T> createNext() {
        return (ShortIdReference)this.referenceList.createNext();
    }

    private ShortIdReference<T> getReference(int i) {
        return (ShortIdReference)this.referenceList.get(i);
    }

    private ShortIdReference<T> getOrCreateReference(int i) {
        this.ensureSize(i + 1);
        return (ShortIdReference)this.referenceList.get(i);
    }

    public T addNewItem(Key key) {
        ShortIdReference<T> item = this.createNext();
        item.setKey(key);
        return (T)item.getItem();
    }

    public void addNewItem(T item) {
        ShortIdReference<T> reference = this.createNext();
        reference.setItem(item);
    }

    public Key getItemKey(int i) {
        ShortIdReference<T> reference = this.getReference(i);
        if (reference != null) {
            return reference.getKey();
        }
        return null;
    }

    public T setItemKeyAt(int index, Key key) {
        ShortIdReference<T> reference = this.getReference(index);
        if (reference != null) {
            reference.setKey(key);
            return (T)reference.getItem();
        }
        return null;
    }

    void getItemKeys(Key[] out) {
        int length = out.length;
        for (int i = 0; i < length; ++i) {
            out[i] = this.getItemKey(i);
        }
    }

    @Override
    public void removeSelf() {
        this.clear();
        super.removeSelf();
    }

    public boolean remove(T item) {
        return this.removeIf(t -> t == item);
    }

    public boolean removeIf(Predicate<? super T> filter) {
        return this.referenceList.removeIf(reference -> filter.test(reference.getItem()));
    }

    void removeNulls() {
        this.removeIf(item -> item == null);
    }

    public Iterator<T> iterator() {
        return ComputeIterator.of(this.referenceList.iterator(), ShortIdReference::getItem);
    }

    public T getItem(int i) {
        ShortIdReference<T> reference = this.getReference(i);
        if (reference != null) {
            return (T)reference.getItem();
        }
        return null;
    }

    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    public boolean sort(Comparator<? super T> comparator) {
        return this.referenceList.sort((ref1, ref2) -> comparator.compare(ref1.getItem(), ref2.getItem()));
    }

    @Override
    protected void onPreRefresh() {
        super.onPreRefresh();
        this.removeNulls();
    }

    public DexPositionAlign getPositionAlign() {
        return this.positionAlign;
    }

    @Override
    public int compareTo(ShortIdList<T> shortIdList) {
        if (shortIdList == this) {
            return 0;
        }
        int size1 = this.size();
        int size2 = shortIdList.size();
        int size = NumbersUtil.min(size1, size2);
        for (int i = 0; i < size; ++i) {
            int c = SectionTool.compareIdx(this.getItem(i), shortIdList.getItem(i));
            if (c == 0) continue;
            return c;
        }
        return CompareUtil.compare(size1, size2);
    }

    public int hashCode() {
        int hash = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            hash = hash * 31 + ObjectsUtil.hash(this.getItem(i));
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShortIdList itemList = (ShortIdList)obj;
        int size = this.size();
        if (size != itemList.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (ObjectsUtil.equals(this.getItem(i), itemList.getItem(i))) continue;
            return false;
        }
        return true;
    }

    static class ReferenceCreator<T extends IdItem>
    implements Creator<ShortIdReference<T>> {
        private final SectionType<T> sectionType;
        private final int usageType;

        ReferenceCreator(SectionType<T> sectionType, int usageType) {
            this.sectionType = sectionType;
            this.usageType = usageType;
        }

        @Override
        public ShortIdReference<T> newInstance() {
            return new ShortIdReference<T>(this.sectionType, this.usageType);
        }
    }
}

