/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.data;

import com.reandroid.dex.base.PositionAlignedItem;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.data.ShortIdList;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.collection.ComputeIterator;
import java.io.IOException;
import java.util.Iterator;

public class TypeList
extends ShortIdList<TypeId>
implements KeyReference,
PositionAlignedItem,
SmaliFormat,
Iterable<TypeId> {
    public TypeList() {
        super(SectionType.TYPE_ID, UsageMarker.USAGE_DEFINITION);
    }

    @Override
    public TypeListKey getKey() {
        Key[] elements = new TypeKey[this.size()];
        this.getItemKeys(elements);
        return this.checkKey(TypeListKey.create(elements));
    }

    public SectionType<TypeList> getSectionType() {
        return SectionType.TYPE_LIST;
    }

    public Iterator<TypeKey> getTypeKeys() {
        return ComputeIterator.of(this.iterator(), TypeId::getKey);
    }

    @Override
    public int size() {
        return super.size();
    }

    public TypeId get(TypeKey typeKey) {
        if (typeKey != null) {
            for (TypeId typeId : this) {
                if (!typeKey.equals(typeId.getKey())) continue;
                return typeId;
            }
        }
        return null;
    }

    public TypeId getTypeIdForRegister(int register) {
        int size = this.size();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            TypeId typeId = (TypeId)this.getItem(i);
            if (count == register) {
                return typeId;
            }
            ++count;
            if (!typeId.isWide()) continue;
            ++count;
        }
        return null;
    }

    public int getParameterRegistersCount() {
        int size = this.size();
        int count = 0;
        for (int i = 0; i < size; ++i) {
            TypeId typeId = (TypeId)this.getItem(i);
            ++count;
            if (!typeId.isWide()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        for (TypeId typeId : this) {
            typeId.append(writer);
        }
    }

    public void appendInterfaces(SmaliWriter writer) throws IOException {
        SmaliDirective smaliDirective = null;
        for (TypeId typeId : this) {
            if (smaliDirective == null) {
                writer.appendCommentNewLine("interfaces");
                smaliDirective = SmaliDirective.IMPLEMENTS;
            }
            writer.newLine();
            smaliDirective.append(writer);
            typeId.append(writer);
        }
        if (smaliDirective != null) {
            writer.newLine();
        }
    }

    @Override
    public boolean isBlank() {
        return this.isRemoved() || this.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (TypeId typeId : this) {
            builder.append(typeId);
        }
        return builder.toString();
    }
}

