/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.debug;

import com.reandroid.dex.debug.DebugElement;
import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.debug.DebugRegisterNumber;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.reference.Base1Ule128IdItemReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliDebugLocal;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class DebugStartLocal
extends DebugRegisterNumber {
    private final Base1Ule128IdItemReference<StringId> mName = new Base1Ule128IdItemReference<StringId>(SectionType.STRING_ID);
    private final Base1Ule128IdItemReference<TypeId> mType = new Base1Ule128IdItemReference<TypeId>(SectionType.TYPE_ID);

    DebugStartLocal(int childesCount, int flag) {
        super(childesCount + 2, flag);
        this.addChild(2, this.mName);
        this.addChild(3, this.mType);
    }

    DebugStartLocal(int childesCount, DebugElementType<?> elementType) {
        this(childesCount, elementType.getFlag());
    }

    public DebugStartLocal() {
        this(0, DebugElementType.START_LOCAL.getFlag());
    }

    @Override
    public boolean isValid() {
        return !this.isRemoved() && this.mName.getItem() != null && this.mType.getItem() != null;
    }

    public String getName() {
        StringId stringId = (StringId)this.mName.getItem();
        if (stringId != null) {
            return stringId.getString();
        }
        return null;
    }

    public StringKey getNameKey() {
        return (StringKey)this.mName.getKey();
    }

    public void setName(String name) {
        this.setName(StringKey.create(name));
    }

    public void setName(StringKey key) {
        this.mName.setKey(key);
    }

    public String getType() {
        TypeId typeId = (TypeId)this.mType.getItem();
        if (typeId != null) {
            return typeId.getName();
        }
        return null;
    }

    public TypeId getTypeId() {
        return (TypeId)this.mType.getItem();
    }

    public TypeKey getTypeKey() {
        return (TypeKey)this.mType.getKey();
    }

    public void setType(String type) {
        this.mType.setKey(TypeKey.create(type));
    }

    public void setType(TypeKey typeKey) {
        this.mType.setKey(typeKey);
    }

    @Override
    public void appendExtra(SmaliWriter writer) throws IOException {
        if (this.isValid()) {
            this.getSmaliDirective().append(writer);
            writer.appendRegister(this.getRegisterNumber());
            writer.append(", ");
            this.mName.append(writer);
            writer.append(':');
            this.mType.append(writer);
        }
    }

    public DebugElementType<? extends DebugStartLocal> getElementType() {
        return DebugElementType.START_LOCAL;
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return CombiningIterator.two(SingleIterator.of((StringId)this.mName.getItem()), SingleIterator.of((TypeId)this.mType.getItem()));
    }

    @Override
    public void merge(DebugElement element) {
        super.merge(element);
        DebugStartLocal coming = (DebugStartLocal)element;
        this.mName.setKey(coming.mName.getKey());
        this.mType.setKey(coming.mType.getKey());
    }

    @Override
    public void fromSmali(Smali smali) {
        super.fromSmali(smali);
        SmaliDebugLocal smaliDebugLocal = (SmaliDebugLocal)smali;
        this.setName(smaliDebugLocal.getName());
        this.setType(smaliDebugLocal.getType());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DebugStartLocal debug = (DebugStartLocal)obj;
        return this.getFlag() == debug.getFlag() && this.getRegisterNumber() == debug.getRegisterNumber() && ObjectsUtil.equals(this.getName(), debug.getName()) && ObjectsUtil.equals(this.getType(), debug.getType());
    }

    @Override
    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getFlag();
        hash = hash * 31 + this.getRegisterNumber();
        hash = hash * 31 + ObjectsUtil.hash(this.getName(), this.getType());
        return hash;
    }

    @Override
    public String toString() {
        return super.toString() + ", " + this.mName + ':' + this.mType;
    }
}

