/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.utils.NumbersUtil;

public class BitItem
extends BlockItem {
    private int bitsLength;

    public BitItem(int bitsLength) {
        super(BitItem.bitsToBytes(bitsLength));
        this.bitsLength = bitsLength;
    }

    public boolean get(int bitIndex) {
        int v = this.readByte(BitItem.byteIndex(bitIndex));
        int b = v >> BitItem.bitIndex(bitIndex) & 1;
        return b == 1;
    }

    public void set(int bitIndex, boolean value) {
        int byteIndex = BitItem.byteIndex(bitIndex);
        this.ensureSize(byteIndex + 1);
        int i = BitItem.bitIndex(bitIndex);
        int v = NumbersUtil.setUInt(this.readByte(byteIndex), value ? 1 : 0, i, 1);
        this.writeByte(byteIndex, v);
    }

    public int append(int offset, BitItem bitItem) {
        int length = bitItem.bitsLength();
        for (int i = 0; i < length; ++i) {
            this.set(offset += i, bitItem.get(i));
        }
        return offset;
    }

    public long getValueUnsigned() {
        byte[] bytes = this.getBytesInternal();
        int i = bytes.length - 1;
        long low = Block.getUnsignedNumber(bytes, 0, i);
        long high = NumbersUtil.getUInt(bytes[i] & 0xFF, 0, BitItem.bitIndex(this.bitsLength()));
        return (high <<= i * 8) | low;
    }

    public int readByte(int byteIndex) {
        return this.getBytesInternal()[byteIndex] & 0xFF;
    }

    public void writeByte(int byteIndex, int byteValue) {
        this.getBytesInternal()[byteIndex] = (byte)byteValue;
    }

    public void ensureSize(int size) {
        if (size > this.size()) {
            this.setSize(size);
        }
    }

    public void setSize(int count) {
        this.setBytesLength(count, false);
    }

    public int size() {
        return this.countBytes();
    }

    public void ensureBitsLength(int length) {
        if (length > this.bitsLength()) {
            this.bitsLength(length);
        }
    }

    public int bitsLength() {
        return this.bitsLength;
    }

    public void bitsLength(int length) {
        this.setBytesLength(BitItem.bitsToBytes(length), true);
        this.bitsLength = length;
    }

    public String toString() {
        return "bits=" + this.bitsLength;
    }

    public static int bitIndex(int bitIndex) {
        return bitIndex & 7;
    }

    public static int wordIndex(int bitIndex) {
        return bitIndex >>> 6;
    }

    public static int byteIndex(int bitIndex) {
        return bitIndex >>> 3;
    }

    public static int bitsToBytes(int numberOfBits) {
        return (numberOfBits + 7 & 0xFFFFFFF8) / 8;
    }
}

