/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.dexopt.BitItem;
import com.reandroid.dex.dexopt.BooleanBit;
import java.io.IOException;
import java.io.OutputStream;

public class BooleanList
extends CountedBlockList<BooleanBit> {
    public BooleanList(IntegerReference countReference) {
        super(BooleanBit.CREATOR, countReference);
    }

    @Override
    public int countBytes() {
        return BitItem.bitsToBytes(this.size());
    }

    @Override
    public byte[] getBytes() {
        int size = this.size();
        if (size == 0) {
            return new byte[0];
        }
        BitItem pool = new BitItem(size);
        for (int i = 0; i < size; ++i) {
            pool.set(i, ((BooleanBit)this.get(i)).get());
        }
        return pool.getBytes();
    }

    public int readFrom(BitItem pool, int poolOffset) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((BooleanBit)this.get(i)).set(pool.get(poolOffset));
            ++poolOffset;
        }
        return poolOffset;
    }

    public int writeTo(BitItem pool, int poolOffset) {
        int size = this.size();
        pool.ensureBitsLength(poolOffset + size);
        for (int i = 0; i < size; ++i) {
            pool.set(poolOffset, ((BooleanBit)this.get(i)).get());
            ++poolOffset;
        }
        return poolOffset;
    }

    @Override
    protected void onReadBytes(BlockReader reader) throws IOException {
        int itemsCount = this.getCountReference().get();
        this.setSize(itemsCount);
        BitItem pool = new BitItem(itemsCount);
        pool.onReadBytes(reader);
        for (int i = 0; i < itemsCount; ++i) {
            ((BooleanBit)this.get(i)).set(pool.get(i));
        }
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        byte[] bytes = this.getBytes();
        int length = bytes.length;
        stream.write(bytes, 0, length);
        return length;
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        counter.setCurrent(this);
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        Block end = counter.END;
        if (end != null && this.get(end.getIndex()) == end) {
            counter.addCount(BitItem.bitsToBytes(end.getIndex()));
            counter.setCurrent(end);
            counter.FOUND = true;
            return;
        }
        counter.addCount(this.countBytes());
    }
}

