/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BooleanReference;
import com.reandroid.arsc.item.IntegerReference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

public class DeflatedBlockContainer
extends FixedBlockContainer {
    private final BooleanReference is_deflated;
    private final IntegerReference sizeUncompressed;
    private final IntegerReference sizeCompressed;

    public DeflatedBlockContainer(int childesCount, BooleanReference is_deflated, IntegerReference sizeUncompressed, IntegerReference sizeCompressed) {
        super(childesCount);
        this.is_deflated = is_deflated;
        this.sizeUncompressed = sizeUncompressed;
        this.sizeCompressed = sizeCompressed;
    }

    public boolean isDeflated() {
        return this.is_deflated.get();
    }

    @Override
    public int countBytes() {
        if (this.isDeflated()) {
            return this.sizeCompressed.get();
        }
        return super.countBytes();
    }

    private void updateDeflatedBytesCount() {
        if (this.isDeflated()) {
            try {
                byte[] bytes = this.deflate(this.sizeUncompressed);
                this.sizeCompressed.set(bytes.length);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.updateDeflatedBytesCount();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        BlockReader deflatedReader;
        if (this.isDeflated()) {
            byte[] uncompressed = DeflatedBlockContainer.readCompressed(reader, this.sizeCompressed.get(), this.sizeUncompressed.get());
            deflatedReader = new BlockReader(uncompressed);
        } else {
            deflatedReader = reader;
        }
        super.onReadBytes(deflatedReader);
    }

    @Override
    public int onWriteBytes(OutputStream stream) throws IOException {
        if (this.isDeflated()) {
            byte[] bytes = this.deflate(null);
            int length = bytes.length;
            stream.write(bytes, 0, length);
            return length;
        }
        return super.onWriteBytes(stream);
    }

    private byte[] deflate(IntegerReference uncompressedReference) throws IOException {
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)arrayOutputStream, new Deflater(1));
        int uncompressed = super.onWriteBytes(deflaterOutputStream);
        if (uncompressedReference != null) {
            uncompressedReference.set(uncompressed);
        }
        deflaterOutputStream.close();
        arrayOutputStream.close();
        return arrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readCompressed(InputStream is, int compressedDataSize, int uncompressedDataSize) throws IOException {
        Inflater inf = new Inflater();
        try {
            int totalBytesRead;
            int bytesRead;
            byte[] result = new byte[uncompressedDataSize];
            int totalBytesInflated = 0;
            byte[] input = new byte[2048];
            for (totalBytesRead = 0; !inf.finished() && !inf.needsDictionary() && totalBytesRead < compressedDataSize; totalBytesRead += bytesRead) {
                bytesRead = is.read(input);
                if (bytesRead < 0) {
                    throw new IOException("Invalid zip data. Stream ended after $totalBytesRead bytes. Expected " + compressedDataSize + " bytes");
                }
                inf.setInput(input, 0, bytesRead);
                try {
                    totalBytesInflated += inf.inflate(result, totalBytesInflated, uncompressedDataSize - totalBytesInflated);
                    continue;
                }
                catch (DataFormatException e) {
                    throw new IOException(e.getMessage());
                }
            }
            if (totalBytesRead != compressedDataSize) {
                throw new IOException("Didn't read enough bytes during decompression. expected=" + compressedDataSize + " actual=" + totalBytesRead);
            }
            if (!inf.finished()) {
                throw new IOException("Inflater did not finish");
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            inf.end();
        }
    }
}

